/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;

public abstract class AssetElementHeader
extends AssetPropertyBase {
    private ElementHeader elementHeaderBean;

    protected AssetElementHeader(ElementHeader elementHeaderBean) {
        super(null);
        this.elementHeaderBean = elementHeaderBean == null ? new ElementHeader() : elementHeaderBean;
    }

    protected AssetElementHeader(AssetDescriptor parentAsset, ElementHeader elementHeaderBean) {
        super(parentAsset);
        this.elementHeaderBean = elementHeaderBean == null ? new ElementHeader() : elementHeaderBean;
    }

    protected AssetElementHeader(AssetDescriptor parentAsset, AssetElementHeader assetElementHeader) {
        super(parentAsset, assetElementHeader);
        this.elementHeaderBean = assetElementHeader == null ? new ElementHeader() : assetElementHeader.getElementHeaderBean();
    }

    protected ElementHeader getElementHeaderBean() {
        return this.elementHeaderBean;
    }

    public AssetElementType getType() {
        ElementType elementTypeBean = this.elementHeaderBean.getType();
        if (elementTypeBean == null) {
            return null;
        }
        return new AssetElementType(elementTypeBean);
    }

    public String getGUID() {
        return this.elementHeaderBean.getGUID();
    }

    public String getURL() {
        return this.elementHeaderBean.getURL();
    }

    public List<AssetClassification> getAssetClassifications() {
        List<Classification> classifications = this.elementHeaderBean.getClassifications();
        if (classifications == null) {
            return null;
        }
        ArrayList<AssetClassification> assetClassifications = new ArrayList<AssetClassification>();
        for (Classification classification : classifications) {
            if (classification == null) continue;
            assetClassifications.add(new AssetClassification(this.getParentAsset(), classification));
        }
        if (assetClassifications.isEmpty()) {
            return null;
        }
        return assetClassifications;
    }

    @Override
    public String toString() {
        return this.elementHeaderBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetElementHeader)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetElementHeader that = (AssetElementHeader)objectToCompare;
        return Objects.equals(this.getElementHeaderBean(), that.getElementHeaderBean());
    }

    @Override
    public int hashCode() {
        return this.elementHeaderBean.hashCode();
    }
}

