/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;

public class AssetSchemaAttribute
extends AssetReferenceable {
    protected SchemaAttribute schemaAttributeBean;
    protected AssetSchemaType assetSchemaType;

    public AssetSchemaAttribute(SchemaAttribute schemaAttributeBean, AssetSchemaType assetSchemaType) {
        super(schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
        this.assetSchemaType = assetSchemaType == null ? null : assetSchemaType.cloneAssetSchemaElement(super.getParentAsset());
    }

    public AssetSchemaAttribute(AssetDescriptor parentAsset, SchemaAttribute schemaAttributeBean, AssetSchemaType assetSchemaType) {
        super(parentAsset, schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
        this.assetSchemaType = assetSchemaType == null ? null : assetSchemaType.cloneAssetSchemaElement(super.getParentAsset());
    }

    public AssetSchemaAttribute(AssetDescriptor parentAsset, AssetSchemaAttribute template) {
        super(parentAsset, template);
        if (template == null) {
            this.schemaAttributeBean = new SchemaAttribute();
            this.assetSchemaType = null;
        } else {
            this.schemaAttributeBean = template.getSchemaAttributeBean();
            AssetSchemaType assetSchemaType = template.getAttributeType();
            this.assetSchemaType = assetSchemaType == null ? null : assetSchemaType.cloneAssetSchemaElement(super.getParentAsset());
        }
    }

    protected SchemaAttribute getSchemaAttributeBean() {
        return this.schemaAttributeBean;
    }

    public String getAttributeName() {
        return this.schemaAttributeBean.getAttributeName();
    }

    public int getElementPosition() {
        return this.schemaAttributeBean.getElementPosition();
    }

    public String getCardinality() {
        return this.schemaAttributeBean.getCardinality();
    }

    public String getDefaultValueOverride() {
        return this.schemaAttributeBean.getDefaultValueOverride();
    }

    public AssetSchemaType getAttributeType() {
        if (this.assetSchemaType == null) {
            return null;
        }
        return this.assetSchemaType.cloneAssetSchemaElement(super.getParentAsset());
    }

    @Override
    public String toString() {
        return this.schemaAttributeBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetSchemaAttribute)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetSchemaAttribute that = (AssetSchemaAttribute)objectToCompare;
        return Objects.equals(this.getSchemaAttributeBean(), that.getSchemaAttributeBean()) && Objects.equals(this.assetSchemaType, that.assetSchemaType);
    }
}

