/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AdditionalProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetMeanings;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;

public abstract class AssetSchemaType
extends AssetReferenceable {
    protected AssetMeanings assetMeanings;

    public AssetSchemaType(SchemaElement schemaElementBean, AssetMeanings assetMeanings) {
        super(schemaElementBean);
        this.assetMeanings = assetMeanings == null ? null : assetMeanings.cloneIterator(super.getParentAsset());
    }

    public AssetSchemaType(AssetDescriptor parentAsset, SchemaElement schemaElementBean, AssetMeanings assetMeanings) {
        super(parentAsset, schemaElementBean);
        this.assetMeanings = assetMeanings == null ? null : assetMeanings.cloneIterator(super.getParentAsset());
    }

    public AssetSchemaType(AssetDescriptor parentAsset, AssetSchemaType templateSchema) {
        super(parentAsset, templateSchema);
        AssetMeanings assetMeanings;
        this.assetMeanings = templateSchema == null ? null : ((assetMeanings = templateSchema.getAssetMeanings()) == null ? null : assetMeanings.cloneIterator(super.getParentAsset()));
    }

    public AssetMeanings getAssetMeanings() {
        if (this.assetMeanings == null) {
            return null;
        }
        return this.assetMeanings.cloneIterator(super.getParentAsset());
    }

    protected abstract AssetSchemaType cloneAssetSchemaElement(AssetDescriptor var1);

    protected abstract SchemaElement getSchemaElementBean();

    public String getVersionNumber() {
        return this.getSchemaElementBean().getVersionNumber();
    }

    public String getAuthor() {
        return this.getSchemaElementBean().getAuthor();
    }

    public String getUsage() {
        return this.getSchemaElementBean().getUsage();
    }

    public String getEncodingStandard() {
        return this.getSchemaElementBean().getEncodingStandard();
    }

    public AdditionalProperties getSchemaProperties() {
        Map<String, Object> schemaProperties = this.getSchemaElementBean().getSchemaProperties();
        if (schemaProperties == null) {
            return null;
        }
        return new AdditionalProperties(super.getParentAsset(), schemaProperties);
    }

    @Override
    public String toString() {
        return "AssetSchemaType{assetMeanings=" + this.assetMeanings + ", referenceableBean=" + this.referenceableBean + ", parentAsset=" + this.parentAsset + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetSchemaType)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetSchemaType that = (AssetSchemaType)objectToCompare;
        return Objects.equals(this.getAssetMeanings(), that.getAssetMeanings());
    }
}

