/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Asset
extends Referenceable {
    protected String displayName = null;
    protected String shortDescription = null;
    protected String description = null;
    protected String owner = null;
    protected List<String> zoneMembership = null;
    protected Map<String, Object> assetProperties = null;

    public Asset() {
    }

    public Asset(Asset templateAsset) {
        super(templateAsset);
        if (templateAsset != null) {
            this.displayName = templateAsset.getDisplayName();
            this.shortDescription = templateAsset.getShortDescription();
            this.description = templateAsset.getDescription();
            this.owner = templateAsset.getOwner();
            this.zoneMembership = templateAsset.getZoneMembership();
            this.assetProperties = templateAsset.getAssetProperties();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public void setAssetProperties(Map<String, Object> assetProperties) {
        this.assetProperties = assetProperties;
    }

    public Map<String, Object> getAssetProperties() {
        if (this.assetProperties == null) {
            return null;
        }
        if (this.assetProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.assetProperties);
    }

    @Override
    public String toString() {
        return "AssetSummary{type=" + this.type + ", qualifiedName='" + this.qualifiedName + '\'' + ", displayName='" + this.displayName + '\'' + ", shortDescription='" + this.shortDescription + '\'' + ", description='" + this.description + '\'' + ", owner='" + this.owner + '\'' + ", classifications=" + this.classifications + '\'' + ", zoneMembership=" + this.zoneMembership + '\'' + ", assetProperties=" + this.assetProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Asset)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Asset asset = (Asset)objectToCompare;
        return Objects.equals(this.getDisplayName(), asset.getDisplayName()) && Objects.equals(this.getShortDescription(), asset.getShortDescription()) && Objects.equals(this.getDescription(), asset.getDescription()) && Objects.equals(this.getOwner(), asset.getOwner()) && Objects.equals(this.getZoneMembership(), asset.getZoneMembership()) && Objects.equals(this.getAssetProperties(), asset.getAssetProperties());
    }
}

