/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Comment
extends Referenceable {
    protected CommentType commentType = null;
    protected String commentText = null;
    protected String user = null;

    public Comment() {
    }

    public Comment(Comment templateComment) {
        super(templateComment);
        if (templateComment != null) {
            this.commentType = templateComment.getCommentType();
            this.user = templateComment.getUser();
            this.commentText = templateComment.getCommentText();
        }
    }

    public CommentType getCommentType() {
        return this.commentType;
    }

    public void setCommentType(CommentType commentType) {
        this.commentType = commentType;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String toString() {
        return "Comment{commentType=" + this.commentType + ", commentText='" + this.commentText + '\'' + ", user='" + this.user + '\'' + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Comment)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Comment comment = (Comment)objectToCompare;
        return this.getCommentType() == comment.getCommentType() && Objects.equals(this.getCommentText(), comment.getCommentText()) && Objects.equals(this.getUser(), comment.getUser());
    }
}

