/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=VirtualConnection.class, name="VirtualConnection")})
public class Connection
extends Referenceable {
    protected String displayName = null;
    protected String description = null;
    protected ConnectorType connectorType = null;
    protected Endpoint endpoint = null;
    protected Map<String, Object> securedProperties = null;

    public static ElementType getConnectionType() {
        String elementTypeId = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
        String elementTypeName = "Connection";
        long elementTypeVersion = 1L;
        String elementTypeDescription = "A set of properties to identify and configure a connector instance.";
        String elementAccessServiceURL = null;
        ElementOrigin elementOrigin = ElementOrigin.LOCAL_COHORT;
        String elementHomeMetadataCollectionId = null;
        ElementType elementType = new ElementType();
        elementType.setElementTypeId("114e9f8f-5ff3-4c32-bd37-a7eb42712253");
        elementType.setElementTypeName("Connection");
        elementType.setElementTypeVersion(1L);
        elementType.setElementTypeDescription("A set of properties to identify and configure a connector instance.");
        elementType.setElementSourceServer(elementAccessServiceURL);
        elementType.setElementOrigin(elementOrigin);
        elementType.setElementHomeMetadataCollectionId(elementHomeMetadataCollectionId);
        return elementType;
    }

    public Connection() {
    }

    public Connection(Connection templateConnection) {
        super(templateConnection);
        if (templateConnection != null) {
            this.displayName = templateConnection.getDisplayName();
            this.description = templateConnection.getDescription();
            this.connectorType = templateConnection.getConnectorType();
            this.endpoint = templateConnection.getEndpoint();
            this.securedProperties = templateConnection.getSecuredProperties();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setConnectorType(ConnectorType connectorType) {
        this.connectorType = connectorType;
    }

    public ConnectorType getConnectorType() {
        if (this.connectorType == null) {
            return null;
        }
        return new ConnectorType(this.connectorType);
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        if (this.endpoint == null) {
            return null;
        }
        return new Endpoint(this.endpoint);
    }

    public void setSecuredProperties(Map<String, Object> securedProperties) {
        this.securedProperties = securedProperties;
    }

    public Map<String, Object> getSecuredProperties() {
        if (this.securedProperties == null) {
            return null;
        }
        if (this.securedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.securedProperties);
    }

    @Override
    public String toString() {
        return "Connection{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", connectorType=" + this.connectorType + ", endpoint=" + this.endpoint + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Connection)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Connection that = (Connection)objectToCompare;
        return Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getConnectorType(), that.getConnectorType()) && Objects.equals(this.getEndpoint(), that.getEndpoint()) && Objects.equals(this.getSecuredProperties(), that.getSecuredProperties());
    }
}

