/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Annotation;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.InformalTag;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Like;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Meaning;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Rating;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Referenceable.class, name="Referenceable"), @JsonSubTypes.Type(value=Annotation.class, name="Annotation"), @JsonSubTypes.Type(value=InformalTag.class, name="InformalTag"), @JsonSubTypes.Type(value=Like.class, name="Like"), @JsonSubTypes.Type(value=Meaning.class, name="Meaning"), @JsonSubTypes.Type(value=Rating.class, name="Rating")})
public class ElementHeader
extends PropertyBase {
    protected ElementType type = null;
    protected String guid = null;
    protected String url = null;
    protected List<Classification> classifications = null;

    public ElementHeader() {
    }

    public ElementHeader(ElementHeader templateHeader) {
        super(templateHeader);
        if (templateHeader != null) {
            this.type = templateHeader.getType();
            this.guid = templateHeader.getGUID();
            this.url = templateHeader.getURL();
            this.classifications = templateHeader.getClassifications();
        }
    }

    public ElementType getType() {
        if (this.type == null) {
            return null;
        }
        return this.type;
    }

    public void setType(ElementType type) {
        this.type = type;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public List<Classification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return new ArrayList<Classification>(this.classifications);
    }

    public void setClassifications(List<Classification> classifications) {
        this.classifications = classifications;
    }

    public String toString() {
        return "ElementHeader{type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ElementHeader)) {
            return false;
        }
        ElementHeader that = (ElementHeader)objectToCompare;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.guid, that.guid) && Objects.equals(this.url, that.url) && Objects.equals(this.getClassifications(), that.getClassifications());
    }

    public int hashCode() {
        return Objects.hash(this.guid);
    }
}

