/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class License
extends Referenceable {
    protected String licenseTypeGUID = null;
    protected String licenseTypeName = null;
    protected String licensee = null;
    protected String summary = null;
    protected ExternalReference link = null;
    protected Date startDate = null;
    protected Date endDate = null;
    protected String licenseConditions = null;
    protected String createdBy = null;
    protected String custodian = null;
    protected String notes = null;

    public License() {
    }

    public License(License templateLicense) {
        super(templateLicense);
        if (templateLicense != null) {
            Date templateEndDate;
            Date templateStartDate;
            this.licenseTypeGUID = templateLicense.getLicenseTypeGUID();
            this.licenseTypeName = templateLicense.getLicenseTypeName();
            this.licensee = templateLicense.getLicensee();
            this.summary = templateLicense.getSummary();
            ExternalReference templateLink = templateLicense.getLink();
            if (templateLink != null) {
                this.link = new ExternalReference(templateLink);
            }
            if ((templateStartDate = templateLicense.getStartDate()) != null) {
                this.startDate = new Date(templateStartDate.getTime());
            }
            if ((templateEndDate = templateLicense.getEndDate()) != null) {
                this.endDate = new Date(templateEndDate.getTime());
            }
            this.licenseConditions = templateLicense.getLicenseConditions();
            this.createdBy = templateLicense.getCreatedBy();
            this.custodian = templateLicense.getCustodian();
            this.notes = templateLicense.getNotes();
        }
    }

    public String getLicenseTypeGUID() {
        return this.licenseTypeGUID;
    }

    public void setLicenseTypeGUID(String licenseTypeGUID) {
        this.licenseTypeGUID = licenseTypeGUID;
    }

    public String getLicenseTypeName() {
        return this.licenseTypeName;
    }

    public void setLicenseTypeName(String licenseTypeName) {
        this.licenseTypeName = licenseTypeName;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public void setLicensee(String licensee) {
        this.licensee = licensee;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public ExternalReference getLink() {
        if (this.link == null) {
            return null;
        }
        return new ExternalReference(this.link);
    }

    public void setLink(ExternalReference link) {
        this.link = link;
    }

    public Date getStartDate() {
        if (this.startDate == null) {
            return null;
        }
        return new Date(this.startDate.getTime());
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        if (this.endDate == null) {
            return null;
        }
        return new Date(this.endDate.getTime());
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getLicenseConditions() {
        return this.licenseConditions;
    }

    public void setLicenseConditions(String licenseConditions) {
        this.licenseConditions = licenseConditions;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCustodian() {
        return this.custodian;
    }

    public void setCustodian(String custodian) {
        this.custodian = custodian;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public String toString() {
        return "License{licenseTypeGUID='" + this.licenseTypeGUID + '\'' + ", licenseTypeName='" + this.licenseTypeName + '\'' + ", licensee='" + this.licensee + '\'' + ", summary='" + this.summary + '\'' + ", link=" + this.link + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", licenseConditions='" + this.licenseConditions + '\'' + ", createdBy='" + this.createdBy + '\'' + ", custodian='" + this.custodian + '\'' + ", notes='" + this.notes + '\'' + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof License)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        License license = (License)objectToCompare;
        return Objects.equals(this.getLicenseTypeGUID(), license.getLicenseTypeGUID()) && Objects.equals(this.licenseTypeName, license.licenseTypeName) && Objects.equals(this.getLicensee(), license.getLicensee()) && Objects.equals(this.getSummary(), license.getSummary()) && Objects.equals(this.getLink(), license.getLink()) && Objects.equals(this.getStartDate(), license.getStartDate()) && Objects.equals(this.getEndDate(), license.getEndDate()) && Objects.equals(this.getLicenseConditions(), license.getLicenseConditions()) && Objects.equals(this.getCreatedBy(), license.getCreatedBy()) && Objects.equals(this.getCustodian(), license.getCustodian()) && Objects.equals(this.getNotes(), license.getNotes());
    }
}

