/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Schema
extends SchemaElement {
    protected SchemaType schemaType = null;
    protected int maximumElements = 0;

    public Schema() {
    }

    public Schema(Schema templateSchema) {
        super(templateSchema);
        if (templateSchema != null) {
            this.schemaType = templateSchema.getSchemaType();
            this.maximumElements = templateSchema.getMaximumElements();
        }
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public int getMaximumElements() {
        if (this.schemaType == SchemaType.STRUCT) {
            return 0;
        }
        return this.maximumElements;
    }

    public void setMaximumElements(int maximumElements) {
        this.maximumElements = maximumElements;
    }

    @Override
    public SchemaElement cloneSchemaElement() {
        return new Schema(this);
    }

    @Override
    public String toString() {
        return "Schema{schemaType=" + this.schemaType + ", maximumElements=" + this.maximumElements + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Schema)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Schema schema = (Schema)objectToCompare;
        return this.getMaximumElements() == schema.getMaximumElements() && this.getSchemaType() == schema.getSchemaType();
    }
}

