/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;

public class AdditionalProperties
extends AssetPropertyBase {
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public AdditionalProperties(Map<String, Object> additionalProperties) {
        this(null, additionalProperties);
    }

    public AdditionalProperties(AssetDescriptor parentAsset, Map<String, Object> additionalProperties) {
        super(parentAsset);
        if (additionalProperties != null) {
            this.additionalProperties = new HashMap<String, Object>(additionalProperties);
        }
    }

    public AdditionalProperties(AssetDescriptor parentAsset, AdditionalProperties templateProperties) {
        super(parentAsset, templateProperties);
        Iterator<String> propertyNames;
        if (templateProperties != null && (propertyNames = templateProperties.getPropertyNames()) != null) {
            while (propertyNames.hasNext()) {
                String newPropertyName = propertyNames.next();
                Object newPropertyValue = templateProperties.getProperty(newPropertyName);
                this.additionalProperties.put(newPropertyName, newPropertyValue);
            }
        }
    }

    public Iterator<String> getPropertyNames() {
        return this.additionalProperties.keySet().iterator();
    }

    public Object getProperty(String name) {
        return this.additionalProperties.get(name);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AdditionalProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AdditionalProperties that = (AdditionalProperties)objectToCompare;
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public String toString() {
        return "AdditionalProperties{additionalProperties=" + this.additionalProperties + ", parentAsset=" + this.parentAsset + '}';
    }
}

