/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectorType
extends Referenceable {
    protected String displayName = null;
    protected String description = null;
    protected String connectorProviderClassName = null;
    protected List<String> recognizedAdditionalProperties = null;
    protected List<String> recognizedSecuredProperties = null;

    public static ElementType getConnectorTypeType() {
        String elementTypeId = "954421eb-33a6-462d-a8ca-b5709a1bd0d4";
        String elementTypeName = "ConnectorType";
        long elementTypeVersion = 1L;
        String elementTypeDescription = "A set of properties describing a type of connector.";
        String elementAccessServiceURL = null;
        ElementOrigin elementOrigin = ElementOrigin.LOCAL_COHORT;
        String elementHomeMetadataCollectionId = null;
        ElementType elementType = new ElementType();
        elementType.setElementTypeId("954421eb-33a6-462d-a8ca-b5709a1bd0d4");
        elementType.setElementTypeName("ConnectorType");
        elementType.setElementTypeVersion(1L);
        elementType.setElementTypeDescription("A set of properties describing a type of connector.");
        elementType.setElementSourceServer(elementAccessServiceURL);
        elementType.setElementOrigin(elementOrigin);
        elementType.setElementHomeMetadataCollectionId(elementHomeMetadataCollectionId);
        return elementType;
    }

    public ConnectorType() {
    }

    public ConnectorType(ConnectorType templateConnectorType) {
        super(templateConnectorType);
        if (templateConnectorType != null) {
            this.displayName = templateConnectorType.getDisplayName();
            this.description = templateConnectorType.getDescription();
            this.connectorProviderClassName = templateConnectorType.getConnectorProviderClassName();
            this.recognizedAdditionalProperties = templateConnectorType.getRecognizedAdditionalProperties();
            this.recognizedSecuredProperties = templateConnectorType.getRecognizedSecuredProperties();
        }
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setConnectorProviderClassName(String connectorProviderClassName) {
        this.connectorProviderClassName = connectorProviderClassName;
    }

    public String getConnectorProviderClassName() {
        return this.connectorProviderClassName;
    }

    public void setRecognizedAdditionalProperties(List<String> recognizedAdditionalProperties) {
        this.recognizedAdditionalProperties = recognizedAdditionalProperties;
    }

    public List<String> getRecognizedAdditionalProperties() {
        return this.recognizedAdditionalProperties;
    }

    public void setRecognizedSecuredProperties(List<String> recognizedSecuredProperties) {
        this.recognizedSecuredProperties = recognizedSecuredProperties;
    }

    public List<String> getRecognizedSecuredProperties() {
        return this.recognizedSecuredProperties;
    }

    @Override
    public String toString() {
        return "ConnectorType{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", connectorProviderClassName='" + this.connectorProviderClassName + '\'' + ", recognizedAdditionalProperties=" + this.recognizedAdditionalProperties + ", recognizedSecuredProperties=" + this.recognizedSecuredProperties + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ConnectorType)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ConnectorType that = (ConnectorType)objectToCompare;
        return Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getConnectorProviderClassName(), that.getConnectorProviderClassName()) && Objects.equals(this.getRecognizedAdditionalProperties(), that.getRecognizedAdditionalProperties()) && Objects.equals(this.getRecognizedSecuredProperties(), that.getRecognizedSecuredProperties());
    }
}

