/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.APIOperation;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.APISchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.BoundedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.MapSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=BoundedSchemaType.class, name="BoundedSchemaType"), @JsonSubTypes.Type(value=ComplexSchemaType.class, name="ComplexSchemaType"), @JsonSubTypes.Type(value=MapSchemaType.class, name="MapSchemaType"), @JsonSubTypes.Type(value=APISchemaType.class, name="APISchemaType"), @JsonSubTypes.Type(value=APIOperation.class, name="APIOperation"), @JsonSubTypes.Type(value=PrimitiveSchemaType.class, name="PrimitiveSchemaType")})
public class SchemaType
extends SchemaElement {
    protected String displayName = null;
    protected String versionNumber = null;
    protected String author = null;
    protected String usage = null;
    protected String encodingStandard = null;

    public SchemaType() {
    }

    public SchemaType(SchemaType templateSchema) {
        super(templateSchema);
        if (templateSchema != null) {
            this.displayName = templateSchema.getDisplayName();
            this.versionNumber = templateSchema.getVersionNumber();
            this.author = templateSchema.getAuthor();
            this.usage = templateSchema.getUsage();
            this.encodingStandard = templateSchema.getEncodingStandard();
            this.schemaProperties = templateSchema.getSchemaProperties();
        }
    }

    @Override
    public SchemaElement cloneSchemaElement() {
        return new SchemaType(this);
    }

    public SchemaType cloneSchemaType() {
        return new SchemaType(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getEncodingStandard() {
        return this.encodingStandard;
    }

    public void setEncodingStandard(String encodingStandard) {
        this.encodingStandard = encodingStandard;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof SchemaType)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaType that = (SchemaType)objectToCompare;
        return Objects.equals(this.getVersionNumber(), that.getVersionNumber()) && Objects.equals(this.getAuthor(), that.getAuthor()) && Objects.equals(this.getUsage(), that.getUsage()) && Objects.equals(this.getEncodingStandard(), that.getEncodingStandard());
    }

    @Override
    public String toString() {
        return "SchemaType{versionNumber='" + this.versionNumber + '\'' + ", author='" + this.author + '\'' + ", usage='" + this.usage + '\'' + ", encodingStandard='" + this.encodingStandard + '\'' + ", schemaProperties=" + this.schemaProperties + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", classifications=" + this.getClassifications() + '}';
    }
}

