/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.ffdc;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class OCFCheckedExceptionBase
extends Exception {
    private int reportedHTTPCode;
    private String reportingClassName;
    private String reportingActionDescription;
    private String reportedErrorMessage;
    private String reportedSystemAction;
    private String reportedUserAction;
    private Throwable reportedCaughtException = null;
    private Map<String, Object> relatedProperties = null;

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
    }

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Map<String, Object> relatedProperties) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.relatedProperties = relatedProperties;
    }

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
    }

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, Map<String, Object> relatedProperties) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
        this.relatedProperties = relatedProperties;
    }

    public OCFCheckedExceptionBase(OCFCheckedExceptionBase template) {
        super(template);
        if (template != null) {
            this.reportedHTTPCode = template.getReportedHTTPCode();
            this.reportingClassName = template.getReportingClassName();
            this.reportingActionDescription = template.getReportingActionDescription();
            this.reportedErrorMessage = template.getErrorMessage();
            this.reportedSystemAction = template.getReportedSystemAction();
            this.reportedUserAction = template.getReportedUserAction();
        }
    }

    public int getReportedHTTPCode() {
        return this.reportedHTTPCode;
    }

    public String getReportingClassName() {
        return this.reportingClassName;
    }

    public String getReportingActionDescription() {
        return this.reportingActionDescription;
    }

    public String getErrorMessage() {
        return this.reportedErrorMessage;
    }

    public String getReportedSystemAction() {
        return this.reportedSystemAction;
    }

    public String getReportedUserAction() {
        return this.reportedUserAction;
    }

    public Throwable getReportedCaughtException() {
        return this.reportedCaughtException;
    }

    public Map<String, Object> getRelatedProperties() {
        if (this.relatedProperties == null) {
            return null;
        }
        if (this.relatedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.relatedProperties);
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof OCFCheckedExceptionBase)) {
            return false;
        }
        OCFCheckedExceptionBase that = (OCFCheckedExceptionBase)objectToCompare;
        return this.getReportedHTTPCode() == that.getReportedHTTPCode() && Objects.equals(this.getReportingClassName(), that.getReportingClassName()) && Objects.equals(this.getReportingActionDescription(), that.getReportingActionDescription()) && Objects.equals(this.reportedErrorMessage, that.reportedErrorMessage) && Objects.equals(this.getReportedSystemAction(), that.getReportedSystemAction()) && Objects.equals(this.getReportedUserAction(), that.getReportedUserAction()) && Objects.equals(this.getRelatedProperties(), that.getRelatedProperties()) && Objects.equals(this.getReportedCaughtException(), that.getReportedCaughtException());
    }

    public int hashCode() {
        return Objects.hash(this.getReportedHTTPCode(), this.getReportingClassName(), this.getReportingActionDescription(), this.reportedErrorMessage, this.getReportedSystemAction(), this.getReportedUserAction(), this.getRelatedProperties(), this.getReportedCaughtException());
    }

    @Override
    public String toString() {
        return "OCFCheckedExceptionBase{, reportedHTTPCode=" + this.reportedHTTPCode + ", reportingClassName='" + this.reportingClassName + '\'' + ", reportingActionDescription='" + this.reportingActionDescription + '\'' + ", reportedErrorMessage='" + this.reportedErrorMessage + '\'' + ", reportedSystemAction='" + this.reportedSystemAction + '\'' + ", reportedUserAction='" + this.reportedUserAction + '\'' + ", reportedCaughtException=" + this.reportedCaughtException + ", relatedProperties=" + this.relatedProperties + ", errorMessage='" + this.getErrorMessage() + '\'' + '}';
    }
}

