/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.ffdc;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCFRuntimeException
extends RuntimeException {
    private int reportedHTTPCode;
    private String reportingClassName;
    private String reportingActionDescription;
    private String reportedErrorMessage;
    private String reportedSystemAction;
    private String reportedUserAction;
    private Throwable reportedCaughtException = null;
    private Map<String, Object> relatedProperties = null;
    private static final Logger log = LoggerFactory.getLogger(OCFRuntimeException.class);

    public OCFRuntimeException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        log.debug(httpCode + ", " + className + ", " + actionDescription);
    }

    public OCFRuntimeException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Map<String, Object> relatedProperties) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.relatedProperties = relatedProperties;
        log.debug(httpCode + ", " + className + ", " + actionDescription);
    }

    public OCFRuntimeException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
        log.debug(httpCode + ", " + className + ", " + actionDescription + ", " + caughtError.toString());
    }

    public OCFRuntimeException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, Map<String, Object> relatedProperties) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
        this.relatedProperties = relatedProperties;
        log.debug(httpCode + ", " + className + ", " + actionDescription + ", " + caughtError.toString());
    }

    public int getReportedHTTPCode() {
        return this.reportedHTTPCode;
    }

    public String getReportingClassName() {
        return this.reportingClassName;
    }

    public String getReportingActionDescription() {
        return this.reportingActionDescription;
    }

    public String getErrorMessage() {
        return this.reportedErrorMessage;
    }

    public String getReportedSystemAction() {
        return this.reportedSystemAction;
    }

    public String getReportedUserAction() {
        return this.reportedUserAction;
    }

    public Throwable getReportedCaughtException() {
        return this.reportedCaughtException;
    }

    public Map<String, Object> getRelatedProperties() {
        if (this.relatedProperties == null) {
            return null;
        }
        if (this.relatedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.relatedProperties);
    }

    @Override
    public String toString() {
        return "OCFRuntimeException{reportedHTTPCode=" + this.reportedHTTPCode + ", reportingClassName='" + this.reportingClassName + '\'' + ", reportingActionDescription='" + this.reportingActionDescription + '\'' + ", reportedErrorMessage='" + this.reportedErrorMessage + '\'' + ", reportedSystemAction='" + this.reportedSystemAction + '\'' + ", reportedUserAction='" + this.reportedUserAction + '\'' + ", reportedCaughtException=" + this.reportedCaughtException + ", relatedProperties=" + this.relatedProperties + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof OCFRuntimeException)) {
            return false;
        }
        OCFRuntimeException that = (OCFRuntimeException)objectToCompare;
        return this.getReportedHTTPCode() == that.getReportedHTTPCode() && Objects.equals(this.getReportingClassName(), that.getReportingClassName()) && Objects.equals(this.getReportingActionDescription(), that.getReportingActionDescription()) && Objects.equals(this.getErrorMessage(), that.getErrorMessage()) && Objects.equals(this.getReportedSystemAction(), that.getReportedSystemAction()) && Objects.equals(this.getReportedUserAction(), that.getReportedUserAction()) && Objects.equals(this.getRelatedProperties(), that.getRelatedProperties()) && Objects.equals(this.getReportedCaughtException(), that.getReportedCaughtException());
    }

    public int hashCode() {
        return Objects.hash(this.getReportedHTTPCode(), this.getReportingClassName(), this.getReportingActionDescription(), this.getErrorMessage(), this.getReportedSystemAction(), this.getReportedUserAction(), this.getRelatedProperties(), this.getReportedCaughtException());
    }
}

