/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.BoundedSchemaCategory;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BoundedSchemaType
extends SchemaType {
    protected BoundedSchemaCategory boundedSchemaCategory = null;
    protected int maximumElements = 0;
    protected SchemaType elementType = null;

    public BoundedSchemaType() {
    }

    public BoundedSchemaType(BoundedSchemaType template) {
        super(template);
        if (template != null) {
            this.boundedSchemaCategory = template.getBoundedSchemaCategory();
            this.maximumElements = template.getMaximumElements();
            this.elementType = template.getElementType();
        }
    }

    @Override
    public SchemaElement cloneSchemaElement() {
        return new BoundedSchemaType(this);
    }

    @Override
    public SchemaType cloneSchemaType() {
        return new BoundedSchemaType(this);
    }

    public BoundedSchemaCategory getBoundedSchemaCategory() {
        return this.boundedSchemaCategory;
    }

    public void setBoundedSchemaCategory(BoundedSchemaCategory boundedSchemaCategory) {
        this.boundedSchemaCategory = boundedSchemaCategory;
    }

    public int getMaximumElements() {
        return this.maximumElements;
    }

    public void setMaximumElements(int maximumElements) {
        this.maximumElements = maximumElements;
    }

    public SchemaType getElementType() {
        return this.elementType;
    }

    public void setElementType(SchemaType elementType) {
        this.elementType = elementType;
    }

    @Override
    public String toString() {
        return "BoundedSchemaType{boundedSchemaCategory=" + this.boundedSchemaCategory + ", maximumElements=" + this.maximumElements + ", elementType=" + this.elementType + ", versionNumber='" + this.getVersionNumber() + '\'' + ", author='" + this.getAuthor() + '\'' + ", usage='" + this.getUsage() + '\'' + ", encodingStandard='" + this.getEncodingStandard() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", extendedProperties=" + this.getExtendedProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", classifications=" + this.getClassifications() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof BoundedSchemaType)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        BoundedSchemaType schema = (BoundedSchemaType)objectToCompare;
        return this.getMaximumElements() == schema.getMaximumElements() && this.getBoundedSchemaCategory() == schema.getBoundedSchemaCategory();
    }
}

