/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PropertyBase;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EmbeddedConnection
extends PropertyBase {
    protected String displayName = null;
    protected Map<String, Object> arguments = null;
    protected Connection embeddedConnection = null;

    public EmbeddedConnection() {
    }

    public EmbeddedConnection(EmbeddedConnection templateEmbeddedConnection) {
        super(templateEmbeddedConnection);
        if (templateEmbeddedConnection != null) {
            this.displayName = templateEmbeddedConnection.getDisplayName();
            this.arguments = templateEmbeddedConnection.getArguments();
            this.embeddedConnection = templateEmbeddedConnection.getEmbeddedConnection();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Map<String, Object> getArguments() {
        if (this.arguments == null) {
            return null;
        }
        if (this.arguments.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.arguments);
    }

    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public Connection getEmbeddedConnection() {
        if (this.embeddedConnection == null) {
            return this.embeddedConnection;
        }
        return new Connection(this.embeddedConnection);
    }

    public void setEmbeddedConnection(Connection embeddedConnection) {
        this.embeddedConnection = embeddedConnection;
    }

    public String toString() {
        return "EmbeddedConnection{displayName='" + this.displayName + '\'' + ", arguments=" + this.arguments + ", embeddedConnection=" + this.embeddedConnection + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof EmbeddedConnection)) {
            return false;
        }
        EmbeddedConnection that = (EmbeddedConnection)objectToCompare;
        return Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getArguments(), that.getArguments()) && Objects.equals(this.getEmbeddedConnection(), that.getEmbeddedConnection());
    }

    public int hashCode() {
        return Objects.hash(this.getDisplayName(), this.getArguments(), this.getEmbeddedConnection());
    }
}

