/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExternalIdentifier
extends Referenceable {
    protected String identifier = null;
    protected String description = null;
    protected String usage = null;
    protected String source = null;
    protected KeyPattern keyPattern = null;
    protected Referenceable scope = null;
    protected String scopeDescription = null;

    public ExternalIdentifier() {
    }

    public ExternalIdentifier(ExternalIdentifier templateExternalIdentifier) {
        super(templateExternalIdentifier);
        if (templateExternalIdentifier != null) {
            this.identifier = templateExternalIdentifier.getIdentifier();
            this.description = templateExternalIdentifier.getDescription();
            this.usage = templateExternalIdentifier.getUsage();
            this.source = templateExternalIdentifier.getSource();
            this.keyPattern = templateExternalIdentifier.getKeyPattern();
            Referenceable templateScope = templateExternalIdentifier.getScope();
            if (templateScope != null) {
                this.scope = new Referenceable(templateScope);
            }
            this.scopeDescription = templateExternalIdentifier.getScopeDescription();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public KeyPattern getKeyPattern() {
        return this.keyPattern;
    }

    public void setKeyPattern(KeyPattern keyPattern) {
        this.keyPattern = keyPattern;
    }

    public Referenceable getScope() {
        if (this.scope == null) {
            return null;
        }
        return new Referenceable(this.scope);
    }

    public void setScope(Referenceable scope) {
        this.scope = scope;
    }

    public String getScopeDescription() {
        return this.scopeDescription;
    }

    public void setScopeDescription(String scopeDescription) {
        this.scopeDescription = scopeDescription;
    }

    @Override
    public String toString() {
        return "ExternalIdentifier{identifier='" + this.identifier + '\'' + ", description='" + this.description + '\'' + ", usage='" + this.usage + '\'' + ", source='" + this.source + '\'' + ", keyPattern=" + this.keyPattern + ", scope=" + this.scope + ", scopeDescription='" + this.scopeDescription + '\'' + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ExternalIdentifier)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ExternalIdentifier that = (ExternalIdentifier)objectToCompare;
        return Objects.equals(this.getIdentifier(), that.getIdentifier()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getUsage(), that.getUsage()) && Objects.equals(this.getSource(), that.getSource()) && this.getKeyPattern() == that.getKeyPattern() && Objects.equals(this.getScope(), that.getScope()) && Objects.equals(this.getScopeDescription(), that.getScopeDescription());
    }
}

