/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetExternalReference;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Certification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;

public class AssetCertification
extends AssetReferenceable {
    protected Certification certificationBean;

    public AssetCertification(Certification certificationBean) {
        super(certificationBean);
        this.certificationBean = certificationBean == null ? new Certification() : certificationBean;
    }

    public AssetCertification(AssetDescriptor parentAsset, Certification certificationBean) {
        super(parentAsset, certificationBean);
        this.certificationBean = certificationBean == null ? new Certification() : certificationBean;
    }

    public AssetCertification(AssetDescriptor parentAsset, AssetCertification templateCertification) {
        super(parentAsset, templateCertification);
        this.certificationBean = templateCertification == null ? new Certification() : templateCertification.getCertificationBean();
    }

    protected Certification getCertificationBean() {
        return this.certificationBean;
    }

    public String getCertificationTypeGUID() {
        return this.certificationBean.getCertificateGUID();
    }

    public String getCertificationTypeName() {
        return this.certificationBean.getCertificationTypeName();
    }

    public String getExaminer() {
        return this.certificationBean.getExaminer();
    }

    public String getSummary() {
        return this.certificationBean.getSummary();
    }

    public AssetExternalReference getLink() {
        ExternalReference link = this.certificationBean.getLink();
        if (link == null) {
            return null;
        }
        return new AssetExternalReference(super.getParentAsset(), link);
    }

    public Date getStartDate() {
        return this.certificationBean.getStartDate();
    }

    public Date getEndDate() {
        return this.certificationBean.getEndDate();
    }

    public String getCertificationConditions() {
        return this.certificationBean.getCertificationConditions();
    }

    public String getCreatedBy() {
        return this.certificationBean.getCreatedBy();
    }

    public String getCustodian() {
        return this.certificationBean.getCustodian();
    }

    public String getNotes() {
        return this.certificationBean.getNotes();
    }

    @Override
    public String toString() {
        return this.certificationBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetCertification)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetCertification that = (AssetCertification)objectToCompare;
        return Objects.equals(this.getCertificationBean(), that.getCertificationBean());
    }
}

