/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaAttributes;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

public class AssetComplexSchemaType
extends AssetSchemaType {
    protected AssetSchemaAttributes schemaAttributes = null;

    protected AssetComplexSchemaType(AssetDescriptor parentAsset) {
        super(parentAsset);
    }

    public AssetComplexSchemaType(SchemaType schemaBean, AssetSchemaAttributes schemaAttributes) {
        super(schemaBean);
        this.schemaAttributes = schemaAttributes;
    }

    public AssetComplexSchemaType(AssetDescriptor parentAsset, ComplexSchemaType schemaBean, AssetSchemaAttributes schemaAttributes) {
        super(parentAsset, schemaBean);
        this.schemaAttributes = schemaAttributes;
    }

    public AssetComplexSchemaType(AssetDescriptor parentAsset, AssetComplexSchemaType templateSchema) {
        super(parentAsset, templateSchema);
        if (templateSchema != null) {
            this.schemaAttributes = templateSchema.getSchemaAttributes(super.getParentAsset());
        }
    }

    protected void setBean(ComplexSchemaType bean) {
        super.setBean(bean);
    }

    public AssetSchemaAttributes getSchemaAttributes() {
        if (this.schemaAttributes == null) {
            return null;
        }
        return this.schemaAttributes.cloneIterator(super.getParentAsset());
    }

    protected AssetSchemaAttributes getSchemaAttributes(AssetDescriptor parentAsset) {
        if (this.schemaAttributes == null) {
            return null;
        }
        return this.schemaAttributes.cloneIterator(parentAsset);
    }

    @Override
    protected AssetSchemaType cloneAssetSchemaType(AssetDescriptor parentAsset) {
        return new AssetComplexSchemaType(parentAsset, this);
    }

    @Override
    public String toString() {
        return "AssetComplexSchemaType{schemaAttributes=" + this.schemaAttributes + ", parentAsset=" + this.parentAsset + ", displayName='" + this.getDisplayName() + '\'' + ", versionNumber='" + this.getVersionNumber() + '\'' + ", author='" + this.getAuthor() + '\'' + ", usage='" + this.getUsage() + '\'' + ", encodingStandard='" + this.getEncodingStandard() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", extendedProperties=" + this.getExtendedProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", assetClassifications=" + this.getAssetClassifications() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetComplexSchemaType that = (AssetComplexSchemaType)objectToCompare;
        return Objects.equals(this.getSchemaAttributes(), that.getSchemaAttributes());
    }
}

