/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.ffdc;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OCFCheckedExceptionBase
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(OCFCheckedExceptionBase.class);
    private int reportedHTTPCode;
    private String reportingClassName;
    private String reportingActionDescription;
    private String reportedErrorMessage;
    private String reportedSystemAction;
    private String reportedUserAction;
    private Throwable reportedCaughtException = null;
    private Map<String, Object> relatedProperties = null;

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.validateCoreProperties();
    }

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Map<String, Object> relatedProperties) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.relatedProperties = relatedProperties;
        this.validateCoreProperties();
    }

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
        this.validateCoreProperties();
    }

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, Map<String, Object> relatedProperties) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
        this.relatedProperties = relatedProperties;
        this.validateCoreProperties();
    }

    public OCFCheckedExceptionBase(String errorMessage, OCFCheckedExceptionBase template) {
        super(errorMessage, template);
        if (template != null) {
            this.reportedHTTPCode = template.getReportedHTTPCode();
            this.reportingClassName = template.getReportingClassName();
            this.reportingActionDescription = template.getReportingActionDescription();
            this.reportedErrorMessage = errorMessage;
            this.reportedSystemAction = template.getReportedSystemAction();
            this.reportedUserAction = template.getReportedUserAction();
        }
        this.validateCoreProperties();
    }

    public OCFCheckedExceptionBase(OCFCheckedExceptionBase template) {
        super(template);
        if (template != null) {
            this.reportedHTTPCode = template.getReportedHTTPCode();
            this.reportingClassName = template.getReportingClassName();
            this.reportingActionDescription = template.getReportingActionDescription();
            this.reportedErrorMessage = template.getErrorMessage();
            this.reportedSystemAction = template.getReportedSystemAction();
            this.reportedUserAction = template.getReportedUserAction();
        }
        this.validateCoreProperties();
    }

    private void validateCoreProperties() {
        if (this.reportedHTTPCode == 0) {
            log.error("Zero HTTP code passed to an exception");
        }
        if (this.reportingClassName == null) {
            log.error("Null class name passed to an exception");
        }
        if (this.reportedErrorMessage == null) {
            log.error("Null error message passed to an exception");
        }
        if (this.reportingActionDescription == null) {
            log.error("Null action description passed to an exception");
        }
        if (this.reportedSystemAction == null) {
            log.error("Null system action passed to an exception");
        }
        if (this.reportedUserAction == null) {
            log.error("Null user action passed to an exception");
        }
    }

    public int getReportedHTTPCode() {
        return this.reportedHTTPCode;
    }

    public String getReportingClassName() {
        return this.reportingClassName;
    }

    public String getReportingActionDescription() {
        return this.reportingActionDescription;
    }

    public String getErrorMessage() {
        return this.reportedErrorMessage;
    }

    public String getReportedSystemAction() {
        return this.reportedSystemAction;
    }

    public String getReportedUserAction() {
        return this.reportedUserAction;
    }

    public Throwable getReportedCaughtException() {
        return this.reportedCaughtException;
    }

    public Map<String, Object> getRelatedProperties() {
        if (this.relatedProperties == null) {
            return null;
        }
        if (this.relatedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.relatedProperties);
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof OCFCheckedExceptionBase)) {
            return false;
        }
        OCFCheckedExceptionBase that = (OCFCheckedExceptionBase)objectToCompare;
        return this.getReportedHTTPCode() == that.getReportedHTTPCode() && Objects.equals(this.getReportingClassName(), that.getReportingClassName()) && Objects.equals(this.getReportingActionDescription(), that.getReportingActionDescription()) && Objects.equals(this.reportedErrorMessage, that.reportedErrorMessage) && Objects.equals(this.getReportedSystemAction(), that.getReportedSystemAction()) && Objects.equals(this.getReportedUserAction(), that.getReportedUserAction()) && Objects.equals(this.getRelatedProperties(), that.getRelatedProperties()) && Objects.equals(this.getReportedCaughtException(), that.getReportedCaughtException());
    }

    public int hashCode() {
        return Objects.hash(this.getReportedHTTPCode(), this.getReportingClassName(), this.getReportingActionDescription(), this.reportedErrorMessage, this.getReportedSystemAction(), this.getReportedUserAction(), this.getRelatedProperties(), this.getReportedCaughtException());
    }

    @Override
    public String toString() {
        return "OCFCheckedExceptionBase{, reportedHTTPCode=" + this.reportedHTTPCode + ", reportingClassName='" + this.reportingClassName + '\'' + ", reportingActionDescription='" + this.reportingActionDescription + '\'' + ", reportedErrorMessage='" + this.reportedErrorMessage + '\'' + ", reportedSystemAction='" + this.reportedSystemAction + '\'' + ", reportedUserAction='" + this.reportedUserAction + '\'' + ", reportedCaughtException=" + this.reportedCaughtException + ", relatedProperties=" + this.relatedProperties + ", errorMessage='" + this.getErrorMessage() + '\'' + '}';
    }
}

