/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.ffdc;

import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

public class UserNotAuthorizedException
extends OCFCheckedExceptionBase {
    private static final long serialVersionUID = 1L;
    private String userId;

    public UserNotAuthorizedException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, String userId) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction);
        this.userId = userId;
    }

    public UserNotAuthorizedException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, String userId, Map<String, Object> relatedProperties) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, relatedProperties);
        this.userId = userId;
    }

    public UserNotAuthorizedException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, String userId) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, caughtError);
        this.userId = userId;
    }

    public UserNotAuthorizedException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, String userId, Map<String, Object> relatedProperties) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, caughtError, relatedProperties);
        this.userId = userId;
    }

    public UserNotAuthorizedException(UserNotAuthorizedException template) {
        super(template);
        if (template != null) {
            this.userId = template.getUserId();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public String toString() {
        return "UserNotAuthorizedException{userId='" + this.userId + '\'' + ", reportedHTTPCode=" + this.getReportedHTTPCode() + ", reportingClassName='" + this.getReportingClassName() + '\'' + ", reportingActionDescription='" + this.getReportingActionDescription() + '\'' + ", errorMessage='" + this.getErrorMessage() + '\'' + ", reportedSystemAction='" + this.getReportedSystemAction() + '\'' + ", reportedUserAction='" + this.getReportedUserAction() + '\'' + ", reportedCaughtException=" + this.getReportedCaughtException() + ", relatedProperties=" + this.getRelatedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        UserNotAuthorizedException that = (UserNotAuthorizedException)objectToCompare;
        return Objects.equals(this.getUserId(), that.getUserId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getUserId());
    }
}

