/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DerivedSchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeRelationship;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DerivedSchemaAttribute.class, name="DerivedSchemaAttribute")})
public class SchemaAttribute
extends SchemaElement {
    private static final long serialVersionUID = 1L;
    protected String attributeName = null;
    protected int elementPosition = 0;
    protected String cardinality = null;
    protected String defaultValueOverride = null;
    protected SchemaType attributeType = null;
    protected SchemaLink externalAttributeType = null;
    protected List<SchemaAttributeRelationship> attributeRelationships = null;

    public SchemaAttribute() {
    }

    public SchemaAttribute(SchemaAttribute template) {
        super(template);
        if (template != null) {
            this.attributeName = template.getAttributeName();
            this.elementPosition = template.getElementPosition();
            this.cardinality = template.getCardinality();
            this.defaultValueOverride = template.getDefaultValueOverride();
            this.attributeType = template.getAttributeType();
            this.externalAttributeType = template.getExternalAttributeType();
            this.attributeRelationships = template.getAttributeRelationships();
        }
    }

    @Override
    public SchemaElement cloneSchemaElement() {
        return new SchemaAttribute(this);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public int getElementPosition() {
        return this.elementPosition;
    }

    public void setElementPosition(int elementPosition) {
        this.elementPosition = elementPosition;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    public String getDefaultValueOverride() {
        return this.defaultValueOverride;
    }

    public void setDefaultValueOverride(String defaultValueOverride) {
        this.defaultValueOverride = defaultValueOverride;
    }

    public SchemaType getAttributeType() {
        if (this.attributeType == null) {
            return null;
        }
        return this.attributeType.cloneSchemaType();
    }

    public void setAttributeType(SchemaType attributeType) {
        this.attributeType = attributeType;
    }

    public SchemaLink getExternalAttributeType() {
        return this.externalAttributeType;
    }

    public void setExternalAttributeType(SchemaLink externalAttributeType) {
        this.externalAttributeType = externalAttributeType;
    }

    public List<SchemaAttributeRelationship> getAttributeRelationships() {
        if (this.attributeRelationships == null) {
            return null;
        }
        if (this.attributeRelationships.isEmpty()) {
            return null;
        }
        return new ArrayList<SchemaAttributeRelationship>(this.attributeRelationships);
    }

    public void setAttributeRelationships(List<SchemaAttributeRelationship> attributeRelationships) {
        this.attributeRelationships = attributeRelationships;
    }

    @Override
    public String toString() {
        return "SchemaAttribute{attributeName='" + this.attributeName + '\'' + ", elementPosition=" + this.elementPosition + ", cardinality='" + this.cardinality + '\'' + ", defaultValueOverride='" + this.defaultValueOverride + '\'' + ", attributeType=" + this.attributeType + ", externalAttributeType=" + this.externalAttributeType + ", attributeRelationships=" + this.attributeRelationships + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", classifications=" + this.getClassifications() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaAttribute that = (SchemaAttribute)objectToCompare;
        return this.getElementPosition() == that.getElementPosition() && Objects.equals(this.getAttributeName(), that.getAttributeName()) && Objects.equals(this.getCardinality(), that.getCardinality()) && Objects.equals(this.getDefaultValueOverride(), that.getDefaultValueOverride()) && Objects.equals(this.getAttributeRelationships(), that.getAttributeRelationships()) && Objects.equals(this.getAttributeType(), that.getAttributeType()) && Objects.equals(this.getExternalAttributeType(), that.getExternalAttributeType());
    }
}

