/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors;

import java.util.UUID;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectorProviderBase
extends ConnectorProvider
implements AuditLoggingComponent {
    private String connectorClassName = null;
    private ComponentDescription connectorComponentDescription = null;
    protected AuditLog auditLog = null;
    protected ConnectorType connectorTypeBean = null;
    private final int hashCode = UUID.randomUUID().hashCode();
    private static final Logger log = LoggerFactory.getLogger(ConnectorProviderBase.class);

    protected String getNewConnectorGUID() {
        UUID newUUID = UUID.randomUUID();
        return newUUID.toString();
    }

    public String getConnectorClassName() {
        return this.connectorClassName;
    }

    protected void setConnectorClassName(String newConnectorClassName) {
        log.debug("Connector class name set: " + newConnectorClassName);
        this.connectorClassName = newConnectorClassName;
    }

    protected void setConnectorComponentDescription(ComponentDescription connectorComponentDescription) {
        log.debug("Connector audit logging component description: " + connectorComponentDescription.toString());
        this.connectorComponentDescription = connectorComponentDescription;
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public ConnectorTypeProperties getConnectorTypeProperties() {
        if (this.connectorTypeBean == null) {
            return null;
        }
        return new ConnectorTypeProperties(this.connectorTypeBean);
    }

    @Override
    public ConnectorType getConnectorType() {
        if (this.connectorTypeBean == null) {
            return null;
        }
        return new ConnectorType(this.connectorTypeBean);
    }

    protected void setConnectorTypeProperties(ConnectorType connectorTypeBean) {
        this.connectorTypeBean = connectorTypeBean;
    }

    @Override
    public Connector getConnector(Connection connection) throws ConnectionCheckedException, ConnectorCheckedException {
        return this.getConnector(new ConnectionProperties(connection));
    }

    @Override
    public Connector getConnector(ConnectionProperties connection) throws ConnectionCheckedException, ConnectorCheckedException {
        Connector connector;
        String methodName = "getConnector";
        log.debug("getConnector called");
        if (connection == null) {
            throw new ConnectionCheckedException(OCFErrorCode.NULL_CONNECTION.getMessageDefinition(), this.getClass().getName(), "getConnector");
        }
        if (this.connectorClassName == null) {
            throw new ConnectionCheckedException(OCFErrorCode.NULL_CONNECTOR_CLASS.getMessageDefinition(), this.getClass().getName(), "getConnector");
        }
        String guid = this.getNewConnectorGUID();
        try {
            Class<?> connectorClass = Class.forName(this.connectorClassName);
            Object potentialConnector = connectorClass.newInstance();
            connector = (Connector)potentialConnector;
            connector.initialize(guid, connection);
            if (connector instanceof AuditLoggingComponent && this.auditLog != null) {
                if (this.connectorComponentDescription == null) {
                    ((AuditLoggingComponent)connector).setAuditLog(this.auditLog);
                } else {
                    ((AuditLoggingComponent)connector).setAuditLog(this.auditLog.createNewAuditLog(this.connectorComponentDescription.getComponentId(), this.connectorComponentDescription.getComponentName() + ":" + guid, this.connectorComponentDescription.getComponentType(), this.connectorComponentDescription.getComponentWikiURL()));
                }
            }
        }
        catch (ClassNotFoundException classException) {
            throw new ConnectionCheckedException(OCFErrorCode.UNKNOWN_CONNECTOR.getMessageDefinition(this.connectorClassName, connection.getConnectionName()), this.getClass().getName(), "getConnector", classException);
        }
        catch (ClassCastException castException) {
            throw new ConnectionCheckedException(OCFErrorCode.NOT_CONNECTOR.getMessageDefinition(this.connectorClassName, connection.getConnectionName()), this.getClass().getName(), "getConnector", castException);
        }
        catch (Throwable unexpectedSomething) {
            throw new ConnectionCheckedException(OCFErrorCode.INVALID_CONNECTOR.getMessageDefinition(this.connectorClassName, connection.getConnectionName()), this.getClass().getName(), "getConnector", unexpectedSomething);
        }
        log.debug("getConnector returns: " + connector.getConnectorInstanceId() + ", " + connection.getConnectionName());
        return connector;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectorProviderBase that = (ConnectorProviderBase)object;
        return this.hashCode == that.hashCode;
    }

    public String toString() {
        return "ConnectorProviderBase{connectorClassName='" + this.connectorClassName + '\'' + ", connectorType=" + this.connectorTypeBean + ", hashCode=" + this.hashCode + '}';
    }
}

