/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;

public class AssetClassification
extends AssetPropertyBase {
    private static final long serialVersionUID = 1L;
    protected Classification classificationBean;

    private String validateName(String name) {
        if (name == null || name.equals("")) {
            throw new OCFRuntimeException(OCFErrorCode.NULL_CLASSIFICATION_NAME.getMessageDefinition(super.getParentAssetName(), super.getParentAssetTypeName()), this.getClass().getName(), "validateName");
        }
        return name;
    }

    protected AssetClassification(Classification classification) {
        super(null);
        this.classificationBean = classification == null ? new Classification() : classification;
        this.validateName(this.classificationBean.getClassificationName());
    }

    protected AssetClassification(AssetDescriptor parentAsset, Classification classification) {
        super(parentAsset);
        this.classificationBean = classification == null ? new Classification() : classification;
        this.validateName(this.classificationBean.getClassificationName());
    }

    public AssetClassification(AssetDescriptor parentAsset, AssetClassification templateClassification) {
        super(parentAsset, templateClassification);
        if (templateClassification == null) {
            throw new OCFRuntimeException(OCFErrorCode.NULL_CLASSIFICATION_NAME.getMessageDefinition("<Unknown>"), this.getClass().getName(), "Copy Constructor");
        }
        this.classificationBean = templateClassification.getClassificationBean();
        this.validateName(this.classificationBean.getClassificationName());
    }

    protected Classification getClassificationBean() {
        return this.classificationBean;
    }

    public String getName() {
        return this.classificationBean.getClassificationName();
    }

    public Map<String, Object> getProperties() {
        return this.classificationBean.getClassificationProperties();
    }

    @Override
    public String toString() {
        return this.classificationBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetClassification)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetClassification that = (AssetClassification)objectToCompare;
        return Objects.equals(this.getClassificationBean(), that.getClassificationBean());
    }

    @Override
    public int hashCode() {
        return this.classificationBean.hashCode();
    }
}

