/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DerivedSchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeCategory;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeRelationship;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DerivedSchemaAttribute.class, name="DerivedSchemaAttribute")})
public class SchemaAttribute
extends SchemaElement {
    private static final long serialVersionUID = 1L;
    protected String attributeName = null;
    protected int elementPosition = 0;
    protected String cardinality = null;
    protected int minCardinality = 0;
    protected int maxCardinality = 0;
    protected boolean allowsDuplicateValues = false;
    protected boolean orderedValues = false;
    protected String defaultValueOverride = null;
    protected DataItemSortOrder sortOrder = null;
    protected int minimumLength = 0;
    protected int length = 0;
    protected int significantDigits = 0;
    protected boolean isNullable = true;
    protected SchemaType attributeType = null;
    protected SchemaLink externalAttributeType = null;
    protected List<SchemaAttributeRelationship> attributeRelationships = null;
    protected String nativeJavaClass = null;
    protected List<String> aliases = null;

    public SchemaAttribute() {
    }

    public SchemaAttribute(SchemaAttribute template) {
        super(template);
        if (template != null) {
            this.attributeName = template.getAttributeName();
            this.elementPosition = template.getElementPosition();
            this.cardinality = template.getCardinality();
            this.minCardinality = template.getMinCardinality();
            this.maxCardinality = template.getMaxCardinality();
            this.allowsDuplicateValues = template.isAllowsDuplicateValues();
            this.orderedValues = template.isOrderedValues();
            this.sortOrder = template.getSortOrder();
            this.minimumLength = template.getMinimumLength();
            this.length = template.getLength();
            this.significantDigits = template.getSignificantDigits();
            this.isNullable = template.isNullable();
            this.defaultValueOverride = template.getDefaultValueOverride();
            this.attributeType = template.getAttributeType();
            this.externalAttributeType = template.getExternalAttributeType();
            this.attributeRelationships = template.getAttributeRelationships();
            this.nativeJavaClass = template.getNativeJavaClass();
            this.aliases = template.getAliases();
        }
    }

    @Override
    public SchemaElement cloneSchemaElement() {
        return new SchemaAttribute(this);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public int getElementPosition() {
        return this.elementPosition;
    }

    public void setElementPosition(int elementPosition) {
        this.elementPosition = elementPosition;
    }

    public SchemaAttributeCategory getCategory() {
        SchemaAttributeCategory category = this.maxCardinality == 0 ? SchemaAttributeCategory.UNKNOWN : (this.maxCardinality == 1 ? SchemaAttributeCategory.SINGLETON : (this.orderedValues ? SchemaAttributeCategory.ARRAY : (this.allowsDuplicateValues ? SchemaAttributeCategory.BAG : SchemaAttributeCategory.SET)));
        return category;
    }

    public void setCategory(SchemaAttributeCategory category) {
    }

    public String getCardinality() {
        String cardinalityDescription;
        if (this.cardinality != null) {
            return this.cardinality;
        }
        if (this.minCardinality < 0 && this.maxCardinality < 0) {
            cardinalityDescription = "*";
        } else {
            cardinalityDescription = this.minCardinality < 1 ? "0.." : this.minCardinality + "..";
            cardinalityDescription = this.maxCardinality < 0 ? cardinalityDescription + "*" : cardinalityDescription + this.maxCardinality;
        }
        return cardinalityDescription;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(int minCardinality) {
        this.minCardinality = minCardinality;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(int maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public boolean isAllowsDuplicateValues() {
        return this.allowsDuplicateValues;
    }

    public void setAllowsDuplicateValues(boolean allowsDuplicateValues) {
        this.allowsDuplicateValues = allowsDuplicateValues;
    }

    public boolean isOrderedValues() {
        return this.orderedValues;
    }

    public void setOrderedValues(boolean orderedValues) {
        this.orderedValues = orderedValues;
    }

    public DataItemSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(DataItemSortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getSignificantDigits() {
        return this.significantDigits;
    }

    public void setSignificantDigits(int significantDigits) {
        this.significantDigits = significantDigits;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public String getDefaultValueOverride() {
        return this.defaultValueOverride;
    }

    public void setDefaultValueOverride(String defaultValueOverride) {
        this.defaultValueOverride = defaultValueOverride;
    }

    public SchemaType getAttributeType() {
        if (this.attributeType == null) {
            return null;
        }
        return this.attributeType.cloneSchemaType();
    }

    public void setAttributeType(SchemaType attributeType) {
        this.attributeType = attributeType;
    }

    public SchemaLink getExternalAttributeType() {
        return this.externalAttributeType;
    }

    public void setExternalAttributeType(SchemaLink externalAttributeType) {
        this.externalAttributeType = externalAttributeType;
    }

    public List<SchemaAttributeRelationship> getAttributeRelationships() {
        if (this.attributeRelationships == null) {
            return null;
        }
        if (this.attributeRelationships.isEmpty()) {
            return null;
        }
        return new ArrayList<SchemaAttributeRelationship>(this.attributeRelationships);
    }

    public void setAttributeRelationships(List<SchemaAttributeRelationship> attributeRelationships) {
        this.attributeRelationships = attributeRelationships;
    }

    public String getNativeJavaClass() {
        return this.nativeJavaClass;
    }

    public void setNativeJavaClass(String nativeJavaClass) {
        this.nativeJavaClass = nativeJavaClass;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    @Override
    public String toString() {
        return "SchemaAttribute{attributeName='" + this.attributeName + '\'' + ", elementPosition=" + this.elementPosition + ", minCardinality=" + this.minCardinality + ", maxCardinality=" + this.maxCardinality + ", allowsDuplicateValues=" + this.allowsDuplicateValues + ", orderedValues=" + this.orderedValues + ", defaultValueOverride='" + this.defaultValueOverride + '\'' + ", sortOrder=" + this.sortOrder + ", attributeType=" + this.attributeType + ", externalAttributeType=" + this.externalAttributeType + ", attributeRelationships=" + this.attributeRelationships + ", nativeJavaClass='" + this.nativeJavaClass + '\'' + ", aliases=" + this.aliases + ", deprecated=" + this.isDeprecated() + ", displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", classifications=" + this.getClassifications() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaAttribute that = (SchemaAttribute)objectToCompare;
        return this.elementPosition == that.elementPosition && this.minCardinality == that.minCardinality && this.maxCardinality == that.maxCardinality && this.allowsDuplicateValues == that.allowsDuplicateValues && this.orderedValues == that.orderedValues && Objects.equals(this.attributeName, that.attributeName) && Objects.equals(this.defaultValueOverride, that.defaultValueOverride) && this.sortOrder == that.sortOrder && Objects.equals(this.attributeType, that.attributeType) && Objects.equals(this.externalAttributeType, that.externalAttributeType) && Objects.equals(this.getAttributeRelationships(), that.getAttributeRelationships()) && Objects.equals(this.nativeJavaClass, that.nativeJavaClass) && Objects.equals(this.aliases, that.aliases);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.attributeName, this.elementPosition, this.minCardinality, this.maxCardinality, this.allowsDuplicateValues, this.orderedValues, this.defaultValueOverride, this.sortOrder, this.attributeType, this.nativeJavaClass, this.aliases);
    }
}

