/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.ffdc;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

public class InvalidParameterException
extends OCFCheckedExceptionBase {
    private static final long serialVersionUID = 1L;
    private String parameterName;

    public InvalidParameterException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, String parameterName) {
        super(messageDefinition, className, actionDescription);
        this.parameterName = parameterName;
    }

    public InvalidParameterException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, String parameterName, Map<String, Object> relatedProperties) {
        super(messageDefinition, className, actionDescription, relatedProperties);
        this.parameterName = parameterName;
    }

    public InvalidParameterException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Throwable caughtError, String parameterName) {
        super(messageDefinition, className, actionDescription, caughtError);
        this.parameterName = parameterName;
    }

    public InvalidParameterException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Throwable caughtError, String parameterName, Map<String, Object> relatedProperties) {
        super(messageDefinition, className, actionDescription, caughtError, relatedProperties);
        this.parameterName = parameterName;
    }

    public InvalidParameterException(int httpCode, String className, String actionDescription, String errorMessage, String errorMessageId, String[] errorMessageParameters, String systemAction, String userAction, String caughtErrorClassName, String parameterName, Map<String, Object> relatedProperties) {
        super(httpCode, className, actionDescription, errorMessage, errorMessageId, errorMessageParameters, systemAction, userAction, caughtErrorClassName, relatedProperties);
        this.parameterName = parameterName;
    }

    public InvalidParameterException(String errorMessage, InvalidParameterException template) {
        super(errorMessage, template);
        if (template != null) {
            this.parameterName = template.getParameterName();
        }
    }

    public InvalidParameterException(InvalidParameterException template) {
        super(template);
        if (template != null) {
            this.parameterName = template.getParameterName();
        }
    }

    public InvalidParameterException(String errorMessage, OCFCheckedExceptionBase template, String parameterName) {
        super(errorMessage, template);
        this.parameterName = parameterName;
    }

    public InvalidParameterException(OCFCheckedExceptionBase template, String parameterName) {
        super(template);
        this.parameterName = parameterName;
    }

    @Deprecated
    public InvalidParameterException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, String parameterName) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction);
        this.parameterName = parameterName;
    }

    @Deprecated
    public InvalidParameterException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, String parameterName, Map<String, Object> relatedProperties) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, relatedProperties);
        this.parameterName = parameterName;
    }

    @Deprecated
    public InvalidParameterException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, String parameterName) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, caughtError);
        this.parameterName = parameterName;
    }

    @Deprecated
    public InvalidParameterException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, String parameterName, Map<String, Object> relatedProperties) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, caughtError, relatedProperties);
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public String toString() {
        return "InvalidParameterException{parameterName='" + this.parameterName + '\'' + ", reportedHTTPCode=" + this.getReportedHTTPCode() + ", reportingClassName='" + this.getReportingClassName() + '\'' + ", reportingActionDescription='" + this.getReportingActionDescription() + '\'' + ", reportedErrorMessage='" + this.getReportedErrorMessage() + '\'' + ", reportedErrorMessageId='" + this.getReportedErrorMessageId() + '\'' + ", reportedErrorMessageParameters=" + Arrays.toString(this.getReportedErrorMessageParameters()) + ", reportedSystemAction='" + this.getReportedSystemAction() + '\'' + ", reportedUserAction='" + this.getReportedUserAction() + '\'' + ", reportedCaughtException=" + this.getReportedCaughtException() + ", reportedCaughtExceptionClassName='" + this.getReportedCaughtExceptionClassName() + '\'' + ", relatedProperties=" + this.getRelatedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InvalidParameterException)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InvalidParameterException that = (InvalidParameterException)objectToCompare;
        return Objects.equals(this.getParameterName(), that.getParameterName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getParameterName());
    }
}

