/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetExternalReference;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.License;

public class AssetLicense
extends AssetReferenceable {
    private static final long serialVersionUID = 1L;
    protected License licenseBean;

    public AssetLicense(License licenseBean) {
        super(licenseBean);
        this.licenseBean = licenseBean == null ? new License() : licenseBean;
    }

    public AssetLicense(AssetDescriptor parentAsset, License licenseBean) {
        super(parentAsset, licenseBean);
        this.licenseBean = licenseBean == null ? new License() : licenseBean;
    }

    public AssetLicense(AssetDescriptor parentAsset, AssetLicense templateLicense) {
        super(parentAsset, templateLicense);
        this.licenseBean = templateLicense == null ? new License() : templateLicense.getLicenseBean();
    }

    protected License getLicenseBean() {
        return this.licenseBean;
    }

    public String getLicenseTypeGUID() {
        return this.licenseBean.getLicenseGUID();
    }

    public String getLicenseTypeName() {
        return this.licenseBean.getLicenseTypeName();
    }

    public String getLicensee() {
        return this.licenseBean.getLicensee();
    }

    public String getSummary() {
        return this.licenseBean.getSummary();
    }

    public AssetExternalReference getLink() {
        ExternalReference link = this.licenseBean.getLink();
        if (link == null) {
            return null;
        }
        return new AssetExternalReference(super.getParentAsset(), link);
    }

    public Date getStartDate() {
        Date startDate = this.licenseBean.getStartDate();
        if (startDate == null) {
            return null;
        }
        return new Date(startDate.getTime());
    }

    public Date getEndDate() {
        Date endDate = this.licenseBean.getEndDate();
        if (endDate == null) {
            return null;
        }
        return new Date(endDate.getTime());
    }

    public String getLicenseConditions() {
        return this.licenseBean.getLicenseConditions();
    }

    public String getCreatedBy() {
        return this.licenseBean.getCreatedBy();
    }

    public String getCustodian() {
        return this.licenseBean.getCustodian();
    }

    public String getNotes() {
        return this.licenseBean.getNotes();
    }

    @Override
    public String toString() {
        return this.licenseBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetLicense)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetLicense that = (AssetLicense)objectToCompare;
        return Objects.equals(this.getLicenseBean(), that.getLicenseBean());
    }
}

