/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum KeyPattern implements Serializable
{
    LOCAL_KEY(0, "Local Key", "Unique key allocated and used within the scope of a single system."),
    RECYCLED_KEY(1, "Recycled Key", "Key allocated and used within the scope of a single system that is periodically reused for different records."),
    NATURAL_KEY(2, "Natural Key", "Key derived from an attribute of the entity, such as email address, passport number."),
    MIRROR_KEY(3, "Mirror Key", "Key value copied from another system."),
    AGGREGATE_KEY(4, "Aggregate Key", "Key formed by combining keys from multiple systems."),
    CALLERS_KEY(5, "Caller's Key", "Key from another system can bey used if system name provided."),
    STABLE_KEY(6, "Stable Key", "Key value will remain active even if records are merged."),
    OTHER(99, "Other", "Another key pattern.");

    private static final long serialVersionUID = 1L;
    private int keyPatternCode;
    private String keyPatternName;
    private String keyPatternDescription;

    private KeyPattern(int keyPatternCode, String keyPatternName, String keyPatternDescription) {
        this.keyPatternCode = keyPatternCode;
        this.keyPatternName = keyPatternName;
        this.keyPatternDescription = keyPatternDescription;
    }

    public int getOrdinal() {
        return this.keyPatternCode;
    }

    public String getName() {
        return this.keyPatternName;
    }

    public String getDescription() {
        return this.keyPatternDescription;
    }

    public String toString() {
        return "KeyPattern{keyPatternCode=" + this.keyPatternCode + ", keyPatternName='" + this.keyPatternName + '\'' + ", keyPatternDescription='" + this.keyPatternDescription + '\'' + '}';
    }
}

