/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=VirtualConnection.class, name="VirtualConnection")})
public class Connection
extends Referenceable {
    private static final long serialVersionUID = 1L;
    private String displayName = null;
    private String description = null;
    private ConnectorType connectorType = null;
    private Endpoint endpoint = null;
    private String userId = null;
    private String encryptedPassword = null;
    private String clearPassword = null;
    private Map<String, Object> configurationProperties = null;
    private Map<String, String> securedProperties = null;
    private String assetSummary = null;

    public static ElementType getConnectionType() {
        String elementTypeId = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
        String elementTypeName = "Connection";
        long elementTypeVersion = 1L;
        String elementTypeDescription = "A set of properties to identify and configure a connector instance.";
        String elementAccessServiceURL = null;
        ElementOrigin elementOrigin = ElementOrigin.LOCAL_COHORT;
        String elementHomeMetadataCollectionId = null;
        ElementType elementType = new ElementType();
        elementType.setElementTypeId("114e9f8f-5ff3-4c32-bd37-a7eb42712253");
        elementType.setElementTypeName("Connection");
        elementType.setElementTypeVersion(1L);
        elementType.setElementTypeDescription("A set of properties to identify and configure a connector instance.");
        elementType.setElementSourceServer(elementAccessServiceURL);
        elementType.setElementOrigin(elementOrigin);
        elementType.setElementMetadataCollectionId(elementHomeMetadataCollectionId);
        return elementType;
    }

    public Connection() {
    }

    public Connection(Connection template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.userId = template.getUserId();
            this.clearPassword = template.getClearPassword();
            this.encryptedPassword = template.getEncryptedPassword();
            this.connectorType = template.getConnectorType();
            this.endpoint = template.getEndpoint();
            this.configurationProperties = template.getConfigurationProperties();
            this.securedProperties = template.getSecuredProperties();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setConnectorType(ConnectorType connectorType) {
        this.connectorType = connectorType;
    }

    public ConnectorType getConnectorType() {
        if (this.connectorType == null) {
            return null;
        }
        return new ConnectorType(this.connectorType);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    public String getClearPassword() {
        return this.clearPassword;
    }

    public void setClearPassword(String clearPassword) {
        this.clearPassword = clearPassword;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        if (this.endpoint == null) {
            return null;
        }
        return new Endpoint(this.endpoint);
    }

    public void setConfigurationProperties(Map<String, Object> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public Map<String, Object> getConfigurationProperties() {
        if (this.configurationProperties == null) {
            return null;
        }
        if (this.configurationProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.configurationProperties);
    }

    public void setSecuredProperties(Map<String, String> securedProperties) {
        this.securedProperties = securedProperties;
    }

    public Map<String, String> getSecuredProperties() {
        if (this.securedProperties == null) {
            return null;
        }
        if (this.securedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.securedProperties);
    }

    public String getAssetSummary() {
        return this.assetSummary;
    }

    public void setAssetSummary(String assetSummary) {
        this.assetSummary = assetSummary;
    }

    @Override
    public String toString() {
        return "Connection{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", connectorType=" + this.connectorType + ", endpoint=" + this.endpoint + ", userId='" + this.userId + '\'' + ", configurationProperties=" + this.configurationProperties + ", assetSummary='" + this.assetSummary + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", securityTags=" + this.getSecurityTags() + ", searchKeywords=" + this.getSearchKeywords() + ", confidentialityGovernanceClassification=" + this.getConfidentialityGovernanceClassification() + ", confidenceGovernanceClassification=" + this.getConfidenceGovernanceClassification() + ", criticalityGovernanceClassification=" + this.getCriticalityGovernanceClassification() + ", retentionGovernanceClassification=" + this.getRetentionGovernanceClassification() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", classifications=" + this.getClassifications() + ", extendedProperties=" + this.getExtendedProperties() + ", headerVersion=" + this.getHeaderVersion() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Connection that = (Connection)objectToCompare;
        return Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getConnectorType(), that.getConnectorType()) && Objects.equals(this.getEndpoint(), that.getEndpoint()) && Objects.equals(this.getUserId(), that.getUserId()) && Objects.equals(this.getEncryptedPassword(), that.getEncryptedPassword()) && Objects.equals(this.getClearPassword(), that.getClearPassword()) && Objects.equals(this.getConfigurationProperties(), that.getConfigurationProperties()) && Objects.equals(this.getSecuredProperties(), that.getSecuredProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDisplayName(), this.getDescription(), this.getConnectorType(), this.getEndpoint(), this.getUserId(), this.getEncryptedPassword(), this.getClearPassword(), this.getSecuredProperties(), this.getConfigurationProperties());
    }
}

