/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.InformalTag;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Like;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Meaning;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Rating;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Referenceable.class, name="Referenceable"), @JsonSubTypes.Type(value=InformalTag.class, name="InformalTag"), @JsonSubTypes.Type(value=Like.class, name="Like"), @JsonSubTypes.Type(value=Meaning.class, name="Meaning"), @JsonSubTypes.Type(value=Rating.class, name="Rating")})
public class ElementHeader
extends PropertyBase {
    private static final long serialVersionUID = 1L;
    protected ElementType type = null;
    protected String guid = null;
    protected String url = null;
    protected List<ElementClassification> classifications = null;
    protected Map<String, Object> extendedProperties = null;

    public ElementHeader() {
    }

    public ElementHeader(ElementHeader template) {
        super(template);
        if (template != null) {
            this.type = template.getType();
            this.guid = template.getGUID();
            this.url = template.getURL();
            this.classifications = template.getClassifications();
            this.extendedProperties = template.getExtendedProperties();
        }
    }

    public ElementType getType() {
        if (this.type == null) {
            return null;
        }
        return this.type;
    }

    public void setType(ElementType type) {
        this.type = type;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public List<ElementClassification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return new ArrayList<ElementClassification>(this.classifications);
    }

    public void setClassifications(List<ElementClassification> classifications) {
        this.classifications = classifications;
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.extendedProperties == null) {
            return null;
        }
        if (this.extendedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.extendedProperties);
    }

    public void setExtendedProperties(Map<String, Object> extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    public String toString() {
        return "ElementHeader{type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + ", extendedProperties=" + this.extendedProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ElementHeader)) {
            return false;
        }
        ElementHeader that = (ElementHeader)objectToCompare;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.guid, that.guid) && Objects.equals(this.url, that.url) && Objects.equals(this.getClassifications(), that.getClassifications()) && Objects.equals(this.getExtendedProperties(), that.getExtendedProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.guid);
    }
}

