/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaImplementationQueries;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DerivedSchemaAttribute;

public class AssetDerivedSchemaAttribute
extends AssetSchemaAttribute {
    private static final long serialVersionUID = 1L;
    protected DerivedSchemaAttribute schemaAttributeBean;
    protected AssetSchemaImplementationQueries queries;

    public AssetDerivedSchemaAttribute(DerivedSchemaAttribute schemaAttributeBean, AssetSchemaImplementationQueries queries) {
        super(schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new DerivedSchemaAttribute() : schemaAttributeBean;
        this.queries = queries;
    }

    public AssetDerivedSchemaAttribute(AssetDescriptor parentAsset, DerivedSchemaAttribute schemaAttributeBean, AssetSchemaImplementationQueries queries) {
        super(parentAsset, schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new DerivedSchemaAttribute() : schemaAttributeBean;
        this.queries = queries;
    }

    public AssetDerivedSchemaAttribute(AssetDescriptor parentAsset, AssetDerivedSchemaAttribute template) {
        super(parentAsset, template);
        if (template == null) {
            this.schemaAttributeBean = new DerivedSchemaAttribute();
            this.queries = null;
        } else {
            this.schemaAttributeBean = template.getDerivedSchemaAttributeBean();
            AssetSchemaImplementationQueries queries = template.getQueries();
            this.queries = queries == null ? null : queries.cloneIterator(super.getParentAsset());
        }
    }

    protected DerivedSchemaAttribute getDerivedSchemaAttributeBean() {
        return this.schemaAttributeBean;
    }

    public String getFormula() {
        return this.schemaAttributeBean.getFormula();
    }

    public AssetSchemaImplementationQueries getQueries() {
        if (this.queries == null) {
            return null;
        }
        return this.queries.cloneIterator(super.getParentAsset());
    }

    @Override
    public AssetSchemaAttribute cloneAssetSchemaAttribute(AssetDescriptor parentAsset) {
        return new AssetDerivedSchemaAttribute(parentAsset, this);
    }

    @Override
    public String toString() {
        return "AssetDerivedSchemaAttribute{formula='" + this.getFormula() + '\'' + ", attributeName='" + this.getAttributeName() + '\'' + ", elementPosition=" + this.getElementPosition() + ", category=" + this.getCategory() + ", cardinality='" + this.getCardinality() + '\'' + ", minCardinality=" + this.getMinCardinality() + ", maxCardinality=" + this.getMaxCardinality() + ", allowsDuplicateValues=" + this.allowsDuplicateValues() + ", hasOrderedValues=" + this.hasOrderedValues() + ", sortOrder=" + this.getSortOrder() + ", defaultValueOverride='" + this.getDefaultValueOverride() + '\'' + ", attributeType=" + this.getAttributeType() + ", externalSchemaLink=" + this.getExternalSchemaLink() + ", attributeRelationships=" + this.getAttributeRelationships() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", meanings=" + this.getMeanings() + ", additionalProperties=" + this.getAdditionalProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetDerivedSchemaAttribute)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetDerivedSchemaAttribute that = (AssetDerivedSchemaAttribute)objectToCompare;
        return Objects.equals(this.getDerivedSchemaAttributeBean(), that.getDerivedSchemaAttributeBean()) && Objects.equals(this.getQueries(), that.getQueries());
    }
}

