/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaAttributeRelationship;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeCategory;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeRelationship;

public class AssetSchemaAttribute
extends AssetReferenceable {
    private static final long serialVersionUID = 1L;
    protected SchemaAttribute schemaAttributeBean;

    protected AssetSchemaAttribute(SchemaAttribute schemaAttributeBean) {
        super(schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
    }

    public AssetSchemaAttribute(AssetDescriptor parentAsset, SchemaAttribute schemaAttributeBean) {
        super(parentAsset, schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
    }

    public AssetSchemaAttribute(AssetDescriptor parentAsset, AssetSchemaAttribute template) {
        super(parentAsset, template);
        this.schemaAttributeBean = template == null ? new SchemaAttribute() : template.getSchemaAttributeBean();
    }

    public AssetSchemaAttribute cloneAssetSchemaAttribute(AssetDescriptor parentAsset) {
        return new AssetSchemaAttribute(parentAsset, this);
    }

    protected SchemaAttribute getSchemaAttributeBean() {
        return this.schemaAttributeBean;
    }

    public String getAttributeName() {
        return this.schemaAttributeBean.getAttributeName();
    }

    public int getElementPosition() {
        return this.schemaAttributeBean.getElementPosition();
    }

    public SchemaAttributeCategory getCategory() {
        return this.schemaAttributeBean.getCategory();
    }

    public String getCardinality() {
        return this.schemaAttributeBean.getCardinality();
    }

    public int getMinCardinality() {
        return this.schemaAttributeBean.getMinCardinality();
    }

    public int getMaxCardinality() {
        return this.schemaAttributeBean.getMaxCardinality();
    }

    public boolean allowsDuplicateValues() {
        return this.schemaAttributeBean.isAllowsDuplicateValues();
    }

    public boolean hasOrderedValues() {
        return this.schemaAttributeBean.isOrderedValues();
    }

    public DataItemSortOrder getSortOrder() {
        return this.schemaAttributeBean.getSortOrder();
    }

    public String getDefaultValueOverride() {
        return this.schemaAttributeBean.getDefaultValueOverride();
    }

    @Deprecated
    public AssetSchemaType getLocalSchemaType() {
        return this.getAttributeType();
    }

    public AssetSchemaType getAttributeType() {
        if (this.schemaAttributeBean != null && this.schemaAttributeBean.getAttributeType() != null) {
            return AssetSchemaType.createAssetSchemaType(this.parentAsset, this.schemaAttributeBean.getAttributeType());
        }
        return null;
    }

    public AssetSchemaLink getExternalSchemaLink() {
        if (this.schemaAttributeBean != null && this.schemaAttributeBean.getExternalAttributeType() != null) {
            return new AssetSchemaLink(super.getParentAsset(), this.schemaAttributeBean.getExternalAttributeType());
        }
        return null;
    }

    public List<AssetSchemaAttributeRelationship> getAttributeRelationships() {
        ArrayList<AssetSchemaAttributeRelationship> attributeRelationships = new ArrayList<AssetSchemaAttributeRelationship>();
        if (this.schemaAttributeBean.getAttributeRelationships() != null) {
            for (SchemaAttributeRelationship attributeRelationship : this.schemaAttributeBean.getAttributeRelationships()) {
                if (attributeRelationship == null) continue;
                attributeRelationships.add(new AssetSchemaAttributeRelationship(super.getParentAsset(), attributeRelationship));
            }
        }
        if (attributeRelationships.isEmpty()) {
            return null;
        }
        return attributeRelationships;
    }

    @Override
    public String toString() {
        return "AssetSchemaAttribute{parentAsset=" + this.parentAsset + ", attributeName='" + this.getAttributeName() + '\'' + ", elementPosition=" + this.getElementPosition() + ", cardinality='" + this.getCardinality() + '\'' + ", defaultValueOverride='" + this.getDefaultValueOverride() + '\'' + ", localSchemaType=" + this.getLocalSchemaType() + ", externalSchemaLink=" + this.getExternalSchemaLink() + ", attributeRelationships=" + this.getAttributeRelationships() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", meanings=" + this.getMeanings() + ", additionalProperties=" + this.getAdditionalProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", assetClassifications=" + this.getAssetClassifications() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetSchemaAttribute that = (AssetSchemaAttribute)objectToCompare;
        return Objects.equals(this.schemaAttributeBean, that.schemaAttributeBean);
    }
}

