/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EmbeddedConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;

public class VirtualConnectionProperties
extends ConnectionProperties {
    private static final long serialVersionUID = 1L;
    protected VirtualConnection connectionBean;

    public VirtualConnectionProperties(VirtualConnection connectionBean) {
        super(connectionBean);
        this.connectionBean = connectionBean == null ? new VirtualConnection() : connectionBean;
    }

    public VirtualConnectionProperties(AssetDescriptor parentAsset, VirtualConnection connectionBean) {
        super(parentAsset, connectionBean);
        this.connectionBean = connectionBean == null ? new VirtualConnection() : connectionBean;
    }

    public VirtualConnectionProperties(VirtualConnectionProperties templateConnection) {
        this(null, templateConnection);
    }

    public VirtualConnectionProperties(AssetDescriptor parentAsset, VirtualConnectionProperties templateConnection) {
        super(parentAsset, templateConnection);
        this.connectionBean = templateConnection == null ? new VirtualConnection() : new VirtualConnection(templateConnection.getConnectionBean());
    }

    @Override
    protected VirtualConnection getConnectionBean() {
        return this.connectionBean;
    }

    public List<EmbeddedConnectionProperties> getEmbeddedConnections() {
        List<EmbeddedConnection> embeddedConnectionBeans = this.connectionBean.getEmbeddedConnections();
        if (embeddedConnectionBeans == null) {
            return null;
        }
        ArrayList<EmbeddedConnectionProperties> embeddedConnectionPropertiesList = new ArrayList<EmbeddedConnectionProperties>();
        for (EmbeddedConnection embeddedConnectionBean : embeddedConnectionBeans) {
            embeddedConnectionPropertiesList.add(new EmbeddedConnectionProperties(super.getParentAsset(), embeddedConnectionBean));
        }
        return embeddedConnectionPropertiesList;
    }

    @Override
    public String getConnectionName() {
        String connectionName = "<Unknown>";
        String qualifiedName = this.connectionBean.getQualifiedName();
        String displayName = this.connectionBean.getDisplayName();
        if (qualifiedName != null && !qualifiedName.equals("")) {
            connectionName = qualifiedName;
        } else if (displayName != null && !displayName.equals("")) {
            connectionName = displayName;
        }
        return connectionName;
    }

    @Override
    public String getDescription() {
        return this.connectionBean.getDescription();
    }

    @Override
    public ConnectorTypeProperties getConnectorType() {
        ConnectorType connectorType = this.connectionBean.getConnectorType();
        if (connectorType == null) {
            return null;
        }
        return new ConnectorTypeProperties(super.getParentAsset(), connectorType);
    }

    @Override
    public EndpointProperties getEndpoint() {
        Endpoint endpoint = this.connectionBean.getEndpoint();
        if (endpoint == null) {
            return null;
        }
        return new EndpointProperties(super.getParentAsset(), endpoint);
    }

    @Override
    protected Map<String, Object> getSecuredProperties() {
        return this.connectionBean.getSecuredProperties();
    }

    @Override
    public String toString() {
        return this.connectionBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof VirtualConnectionProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        VirtualConnectionProperties that = (VirtualConnectionProperties)objectToCompare;
        return Objects.equals(this.getConnectionBean(), that.getConnectionBean());
    }
}

