/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaLink
extends SchemaElement {
    private static final long serialVersionUID = 1L;
    protected String linkType = null;
    protected String linkName = null;
    protected Map<String, String> linkProperties = null;
    protected String linkedSchemaTypeGUID = null;
    protected String linkedSchemaTypeName = null;

    public SchemaLink() {
    }

    public SchemaLink(SchemaLink template) {
        super(template);
        if (template != null) {
            this.linkName = template.getLinkName();
            this.linkType = template.getLinkType();
            this.linkProperties = template.getLinkProperties();
            this.linkedSchemaTypeGUID = template.getLinkedSchemaTypeGUID();
            this.linkedSchemaTypeName = template.getLinkedSchemaTypeName();
        }
    }

    @Override
    public SchemaElement cloneSchemaElement() {
        return new SchemaLink(this);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public Map<String, String> getLinkProperties() {
        if (this.linkProperties == null) {
            return null;
        }
        if (this.linkProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.linkProperties);
    }

    public void setLinkProperties(Map<String, String> linkProperties) {
        this.linkProperties = linkProperties;
    }

    public String getLinkedSchemaTypeGUID() {
        return this.linkedSchemaTypeGUID;
    }

    public void setLinkedSchemaTypeGUID(String linkedSchemaTypeGUID) {
        this.linkedSchemaTypeGUID = linkedSchemaTypeGUID;
    }

    public String getLinkedSchemaTypeName() {
        return this.linkedSchemaTypeName;
    }

    public void setLinkedSchemaTypeName(String linkedSchemaTypeName) {
        this.linkedSchemaTypeName = linkedSchemaTypeName;
    }

    @Override
    public String toString() {
        return "SchemaLink{linkType='" + this.linkType + '\'' + ", linkName='" + this.linkName + '\'' + ", linkProperties=" + this.linkProperties + ", linkedSchemaTypeGUID='" + this.linkedSchemaTypeGUID + '\'' + ", linkedSchemaTypeName='" + this.linkedSchemaTypeName + '\'' + ", deprecated=" + this.isDeprecated() + ", displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", classifications=" + this.getClassifications() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof SchemaLink)) {
            return false;
        }
        SchemaLink that = (SchemaLink)objectToCompare;
        return Objects.equals(this.getLinkType(), that.getLinkType()) && Objects.equals(this.getLinkName(), that.getLinkName()) && Objects.equals(this.getLinkProperties(), that.getLinkProperties()) && Objects.equals(this.getLinkedSchemaTypeGUID(), that.getLinkedSchemaTypeGUID()) && Objects.equals(this.getLinkedSchemaTypeName(), that.getLinkedSchemaTypeName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getLinkType(), this.getLinkName(), this.getLinkProperties(), this.getLinkedSchemaTypeGUID());
    }
}

