/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Certification
extends Referenceable {
    private static final long serialVersionUID = 1L;
    protected String certificateGUID = null;
    protected String certificationTypeName = null;
    protected String examiner = null;
    protected String summary = null;
    protected ExternalReference link = null;
    protected Date startDate = null;
    protected Date endDate = null;
    protected String certificationConditions = null;
    protected String createdBy = null;
    protected String custodian = null;
    protected String recipient = null;
    protected String notes = null;

    public Certification() {
    }

    public Certification(Certification templateCertification) {
        super(templateCertification);
        if (templateCertification != null) {
            Date templateEndDate;
            Date templateStartDate;
            this.certificateGUID = templateCertification.getCertificateGUID();
            this.certificationTypeName = templateCertification.getCertificationTypeName();
            this.examiner = templateCertification.getExaminer();
            this.summary = templateCertification.getSummary();
            ExternalReference templateLink = templateCertification.getLink();
            if (templateLink != null) {
                this.link = new ExternalReference(templateLink);
            }
            if ((templateStartDate = templateCertification.getStartDate()) != null) {
                this.startDate = new Date(templateStartDate.getTime());
            }
            if ((templateEndDate = templateCertification.getEndDate()) != null) {
                this.endDate = new Date(templateEndDate.getTime());
            }
            this.certificationConditions = templateCertification.getCertificationConditions();
            this.createdBy = templateCertification.getCreatedBy();
            this.custodian = templateCertification.getCustodian();
            this.recipient = templateCertification.getRecipient();
            this.notes = templateCertification.getNotes();
        }
    }

    public String getCertificateGUID() {
        return this.certificateGUID;
    }

    public void setCertificateGUID(String certificateGUID) {
        this.certificateGUID = certificateGUID;
    }

    public String getCertificationTypeName() {
        return this.certificationTypeName;
    }

    public void setCertificationTypeName(String certificationTypeName) {
        this.certificationTypeName = certificationTypeName;
    }

    public String getExaminer() {
        return this.examiner;
    }

    public void setExaminer(String examiner) {
        this.examiner = examiner;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setLink(ExternalReference link) {
        this.link = link;
    }

    public ExternalReference getLink() {
        if (this.link == null) {
            return null;
        }
        return new ExternalReference(this.link);
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        if (this.startDate == null) {
            return null;
        }
        return new Date(this.startDate.getTime());
    }

    public Date getEndDate() {
        if (this.endDate == null) {
            return null;
        }
        return new Date(this.endDate.getTime());
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getCertificationConditions() {
        return this.certificationConditions;
    }

    public void setCertificationConditions(String certificationConditions) {
        this.certificationConditions = certificationConditions;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCustodian() {
        return this.custodian;
    }

    public void setCustodian(String custodian) {
        this.custodian = custodian;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public String toString() {
        return "Certification{certificateGUID='" + this.certificateGUID + '\'' + ", certificationTypeName='" + this.certificationTypeName + '\'' + ", examiner='" + this.examiner + '\'' + ", summary='" + this.summary + '\'' + ", link=" + this.link + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", certificationConditions='" + this.certificationConditions + '\'' + ", createdBy='" + this.createdBy + '\'' + ", custodian='" + this.custodian + '\'' + ", recipient='" + this.recipient + '\'' + ", notes='" + this.notes + '\'' + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Certification)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Certification that = (Certification)objectToCompare;
        return Objects.equals(this.getCertificateGUID(), that.getCertificateGUID()) && Objects.equals(this.getCertificationTypeName(), that.getCertificationTypeName()) && Objects.equals(this.getExaminer(), that.getExaminer()) && Objects.equals(this.getSummary(), that.getSummary()) && Objects.equals(this.getLink(), that.getLink()) && Objects.equals(this.getStartDate(), that.getStartDate()) && Objects.equals(this.getEndDate(), that.getEndDate()) && Objects.equals(this.getCertificationConditions(), that.getCertificationConditions()) && Objects.equals(this.getCreatedBy(), that.getCreatedBy()) && Objects.equals(this.getCustodian(), that.getCustodian()) && Objects.equals(this.getRecipient(), that.getRecipient()) && Objects.equals(this.getNotes(), that.getNotes());
    }
}

