/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ClassificationOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SecurityTags;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ElementClassification.class, name="ElementClassification"), @JsonSubTypes.Type(value=SecurityTags.class, name="SecurityTags")})
public class ElementClassificationHeader
extends ElementControlHeader {
    private static final long serialVersionUID = 1L;
    private String classificationTypeId = null;
    private long classificationTypeVersion = 0L;
    private String classificationTypeDescription = null;
    private ClassificationOrigin classificationOrigin = ClassificationOrigin.ASSIGNED;
    private String classificationOriginGUID = null;

    public ElementClassificationHeader() {
    }

    public ElementClassificationHeader(ElementClassificationHeader template) {
        super(template);
        if (template != null) {
            this.classificationTypeId = template.getClassificationTypeId();
            this.classificationTypeVersion = template.getClassificationTypeVersion();
            this.classificationTypeDescription = template.getClassificationTypeDescription();
            this.classificationOrigin = template.getClassificationOrigin();
            this.classificationOriginGUID = template.getClassificationOriginGUID();
        }
    }

    public void setClassificationTypeId(String classificationTypeId) {
        this.classificationTypeId = classificationTypeId;
    }

    public String getClassificationTypeId() {
        return this.classificationTypeId;
    }

    public void setClassificationTypeVersion(long classificationTypeVersion) {
        this.classificationTypeVersion = classificationTypeVersion;
    }

    public long getClassificationTypeVersion() {
        return this.classificationTypeVersion;
    }

    public void setClassificationTypeDescription(String classificationTypeDescription) {
        this.classificationTypeDescription = classificationTypeDescription;
    }

    public String getClassificationTypeDescription() {
        return this.classificationTypeDescription;
    }

    public ClassificationOrigin getClassificationOrigin() {
        return this.classificationOrigin;
    }

    public void setClassificationOrigin(ClassificationOrigin classificationOrigin) {
        this.classificationOrigin = classificationOrigin;
    }

    public String getClassificationOriginGUID() {
        return this.classificationOriginGUID;
    }

    public void setClassificationOriginGUID(String classificationOriginGUID) {
        this.classificationOriginGUID = classificationOriginGUID;
    }

    @Override
    public String toString() {
        return "ElementClassificationHeader{elementTypeId='" + this.classificationTypeId + '\'' + ", elementTypeVersion=" + this.classificationTypeVersion + ", elementTypeDescription='" + this.classificationTypeDescription + '\'' + ", classificationOrigin=" + this.classificationOrigin + ", classificationOriginGUID='" + this.classificationOriginGUID + '\'' + ", elementSourceServer='" + this.getElementSourceServer() + '\'' + ", elementOrigin=" + this.getElementOrigin() + ", elementMetadataCollectionId='" + this.getElementMetadataCollectionId() + '\'' + ", elementMetadataCollectionName='" + this.getElementMetadataCollectionName() + '\'' + ", elementLicense='" + this.getElementLicense() + '\'' + ", status=" + this.getStatus() + ", elementCreatedBy='" + this.getElementCreatedBy() + '\'' + ", elementUpdatedBy='" + this.getElementUpdatedBy() + '\'' + ", elementMaintainedBy=" + this.getElementMaintainedBy() + ", elementCreateTime=" + this.getElementCreateTime() + ", elementUpdateTime=" + this.getElementUpdateTime() + ", elementVersion=" + this.getElementVersion() + ", mappingProperties=" + this.getMappingProperties() + ", headerVersion=" + this.getHeaderVersion() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ElementClassificationHeader that = (ElementClassificationHeader)objectToCompare;
        return this.classificationTypeVersion == that.classificationTypeVersion && Objects.equals(this.classificationTypeId, that.classificationTypeId) && Objects.equals(this.classificationTypeDescription, that.classificationTypeDescription) && this.classificationOrigin == that.classificationOrigin && Objects.equals(this.classificationOriginGUID, that.classificationOriginGUID);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.classificationTypeId, this.classificationTypeVersion, this.classificationTypeDescription, this.classificationOrigin, this.classificationOriginGUID);
    }
}

