/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaAttributes;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;

public class AssetComplexSchemaType
extends AssetSchemaType {
    private static final long serialVersionUID = 1L;
    protected ComplexSchemaType complexSchemaTypeBean = null;
    protected AssetSchemaAttributes schemaAttributes = null;

    protected AssetComplexSchemaType(AssetDescriptor parentAsset) {
        super(parentAsset);
    }

    public AssetComplexSchemaType(ComplexSchemaType schemaBean) {
        super(schemaBean);
        this.complexSchemaTypeBean = schemaBean;
    }

    public AssetComplexSchemaType(AssetDescriptor parentAsset, ComplexSchemaType schemaBean) {
        super(parentAsset, schemaBean);
        this.complexSchemaTypeBean = schemaBean;
    }

    public AssetComplexSchemaType(AssetDescriptor parentAsset, AssetComplexSchemaType template) {
        super(parentAsset, template);
        if (template != null) {
            this.complexSchemaTypeBean = template.getComplexSchemaTypeBean();
            this.schemaAttributes = template.getSchemaAttributes(parentAsset);
        }
    }

    protected void setBean(ComplexSchemaType bean) {
        super.setBean(bean);
    }

    protected ComplexSchemaType getComplexSchemaTypeBean() {
        return this.complexSchemaTypeBean;
    }

    public AssetSchemaAttributes getSchemaAttributes() {
        if (this.schemaAttributes == null) {
            return null;
        }
        return this.getSchemaAttributes(this.parentAsset);
    }

    protected AssetSchemaAttributes getSchemaAttributes(AssetDescriptor parentAsset) {
        if (this.schemaAttributes == null) {
            return null;
        }
        return this.schemaAttributes.cloneIterator(parentAsset);
    }

    @Override
    protected AssetSchemaType cloneAssetSchemaType(AssetDescriptor parentAsset) {
        return new AssetComplexSchemaType(parentAsset, this);
    }

    @Override
    public String toString() {
        return "AssetComplexSchemaType{schemaAttributes=" + this.schemaAttributes + ", parentAsset=" + this.parentAsset + ", versionNumber='" + this.getVersionNumber() + '\'' + ", author='" + this.getAuthor() + '\'' + ", usage='" + this.getUsage() + '\'' + ", encodingStandard='" + this.getEncodingStandard() + '\'' + ", formula='" + this.getFormula() + '\'' + ", queries=" + this.getQueries() + ", deprecated=" + this.isDeprecated() + ", displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", meanings=" + this.getMeanings() + ", securityTags=" + this.getSecurityTags() + ", additionalProperties=" + this.getAdditionalProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", assetClassifications=" + this.getAssetClassifications() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetComplexSchemaType that = (AssetComplexSchemaType)objectToCompare;
        return Objects.equals(this.getSchemaAttributes(), that.getSchemaAttributes());
    }
}

