/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;

public class ConnectionProperties
extends AssetReferenceable {
    private static final long serialVersionUID = 1L;
    protected Connection connectionBean;

    public ConnectionProperties(Connection connectionBean) {
        super(connectionBean);
        this.connectionBean = connectionBean == null ? new Connection() : connectionBean;
    }

    public ConnectionProperties(AssetDescriptor parentAsset, Connection connectionBean) {
        super(parentAsset, connectionBean);
        this.connectionBean = connectionBean == null ? new Connection() : connectionBean;
    }

    public ConnectionProperties(ConnectionProperties templateConnection) {
        this(null, templateConnection);
    }

    public ConnectionProperties(AssetDescriptor parentAsset, ConnectionProperties templateConnection) {
        super(parentAsset, templateConnection);
        this.connectionBean = templateConnection == null ? new Connection() : new Connection(templateConnection.getConnectionBean());
    }

    protected Connection getConnectionBean() {
        return this.connectionBean;
    }

    public String getDisplayName() {
        return this.connectionBean.getDisplayName();
    }

    public String getConnectionName() {
        String connectionName = "<Unknown>";
        String qualifiedName = this.connectionBean.getQualifiedName();
        String displayName = this.connectionBean.getDisplayName();
        if (qualifiedName != null && !qualifiedName.equals("")) {
            connectionName = qualifiedName;
        } else if (displayName != null && !displayName.equals("")) {
            connectionName = displayName;
        }
        return connectionName;
    }

    public String getDescription() {
        return this.connectionBean.getDescription();
    }

    public ConnectorTypeProperties getConnectorType() {
        ConnectorType connectorType = this.connectionBean.getConnectorType();
        if (connectorType == null) {
            return null;
        }
        return new ConnectorTypeProperties(super.getParentAsset(), connectorType);
    }

    public String getUserId() {
        return this.connectionBean.getUserId();
    }

    public String getEncryptedPassword() {
        return this.connectionBean.getEncryptedPassword();
    }

    public String getClearPassword() {
        return this.connectionBean.getClearPassword();
    }

    public EndpointProperties getEndpoint() {
        Endpoint endpoint = this.connectionBean.getEndpoint();
        if (endpoint == null) {
            return null;
        }
        return new EndpointProperties(super.getParentAsset(), endpoint);
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.connectionBean.getConfigurationProperties();
    }

    protected Map<String, String> getSecuredProperties() {
        return this.connectionBean.getSecuredProperties();
    }

    @Override
    public String toString() {
        return this.connectionBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ConnectionProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ConnectionProperties that = (ConnectionProperties)objectToCompare;
        return Objects.equals(this.getConnectionBean(), that.getConnectionBean());
    }
}

