/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Endpoint
extends Referenceable {
    private static final long serialVersionUID = 1L;
    protected String displayName = null;
    protected String description = null;
    protected String address = null;
    protected String protocol = null;
    protected String encryptionMethod = null;

    public static ElementType getEndpointType() {
        String elementTypeId = "dbc20663-d705-4ff0-8424-80c262c6b8e7";
        String elementTypeName = "Endpoint";
        long elementTypeVersion = 1L;
        String elementTypeDescription = "Description of the network address and related information needed to call a software service.";
        String elementAccessServiceURL = null;
        ElementOrigin elementOrigin = ElementOrigin.LOCAL_COHORT;
        String elementHomeMetadataCollectionId = null;
        ElementType elementType = new ElementType();
        elementType.setElementTypeId("dbc20663-d705-4ff0-8424-80c262c6b8e7");
        elementType.setElementTypeName("Endpoint");
        elementType.setElementTypeVersion(1L);
        elementType.setElementTypeDescription("Description of the network address and related information needed to call a software service.");
        elementType.setElementSourceServer(elementAccessServiceURL);
        elementType.setElementOrigin(elementOrigin);
        elementType.setElementMetadataCollectionId(elementHomeMetadataCollectionId);
        return elementType;
    }

    public Endpoint() {
    }

    public Endpoint(Endpoint templateEndpoint) {
        super(templateEndpoint);
        if (templateEndpoint != null) {
            this.displayName = templateEndpoint.getDisplayName();
            this.description = templateEndpoint.getDescription();
            this.address = templateEndpoint.getAddress();
            this.protocol = templateEndpoint.getProtocol();
            this.encryptionMethod = templateEndpoint.getEncryptionMethod();
        }
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setEncryptionMethod(String encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    @Override
    public String toString() {
        return "Endpoint{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", address='" + this.address + '\'' + ", protocol='" + this.protocol + '\'' + ", encryptionMethod='" + this.encryptionMethod + '\'' + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Endpoint)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)objectToCompare;
        return Objects.equals(this.getDisplayName(), endpoint.getDisplayName()) && Objects.equals(this.getDescription(), endpoint.getDescription()) && Objects.equals(this.getAddress(), endpoint.getAddress()) && Objects.equals(this.getProtocol(), endpoint.getProtocol()) && Objects.equals(this.getEncryptionMethod(), endpoint.getEncryptionMethod());
    }
}

