/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDetail;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetRelatedAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSummary;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;

public abstract class RelatedAssetProperties
extends AssetPropertyElementBase {
    private static final long serialVersionUID = 1L;
    protected AssetUniverse assetProperties = null;
    protected AssetDescriptor connectedAsset = null;
    protected AssetRelatedAsset relatedAsset = null;

    protected RelatedAssetProperties() {
    }

    public RelatedAssetProperties(AssetDescriptor connectedAsset, AssetRelatedAsset relatedAsset) {
        this.connectedAsset = connectedAsset;
        this.relatedAsset = relatedAsset;
    }

    public RelatedAssetProperties(RelatedAssetProperties templateProperties) {
        AssetUniverse templateAssetUniverse;
        if (templateProperties != null && (templateAssetUniverse = templateProperties.getAssetUniverse()) != null) {
            this.assetProperties = new AssetUniverse(templateAssetUniverse);
            this.connectedAsset = templateProperties.connectedAsset;
            this.relatedAsset = templateProperties.relatedAsset;
        }
    }

    public AssetSummary getAssetSummary() {
        return this.assetProperties;
    }

    public AssetDetail getAssetDetail() {
        return this.assetProperties;
    }

    public AssetUniverse getAssetUniverse() {
        return this.assetProperties;
    }

    public abstract void refresh() throws PropertyServerException, UserNotAuthorizedException;

    public String toString() {
        return "RelatedAssetProperties{assetProperties=" + this.assetProperties + ", connectedAsset=" + this.connectedAsset + ", relatedAsset=" + this.relatedAsset + '}';
    }
}

