/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetNotes;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.NoteLog;

public class AssetNoteLog
extends AssetReferenceable {
    private static final long serialVersionUID = 1L;
    protected NoteLog noteLogBean;
    protected AssetNotes notes = null;

    public AssetNoteLog(NoteLog noteLogBean, AssetNotes notes) {
        super(noteLogBean);
        this.noteLogBean = noteLogBean == null ? new NoteLog() : noteLogBean;
        this.notes = notes;
    }

    public AssetNoteLog(AssetDescriptor parentAsset, NoteLog noteLogBean, AssetNotes notes) {
        super(parentAsset, noteLogBean);
        this.noteLogBean = noteLogBean == null ? new NoteLog() : noteLogBean;
        this.notes = notes;
    }

    public AssetNoteLog(AssetDescriptor parentAsset, AssetNoteLog templateNoteLog) {
        super(parentAsset, templateNoteLog);
        if (templateNoteLog == null) {
            this.noteLogBean = new NoteLog();
        } else {
            NoteLog noteLogBean;
            this.noteLogBean = noteLogBean = templateNoteLog.getNoteLogBean();
            AssetNotes templateNotes = templateNoteLog.getNotes();
            if (templateNotes != null) {
                this.notes = templateNotes.cloneIterator(super.getParentAsset());
            }
        }
    }

    protected NoteLog getNoteLogBean() {
        return this.noteLogBean;
    }

    public String getDisplayName() {
        return this.noteLogBean.getDisplayName();
    }

    public String getDescription() {
        return this.noteLogBean.getDescription();
    }

    public AssetNotes getNotes() {
        if (this.notes == null) {
            return null;
        }
        return this.notes.cloneIterator(super.getParentAsset());
    }

    @Override
    public String toString() {
        return this.noteLogBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetNoteLog that = (AssetNoteLog)objectToCompare;
        return Objects.equals(this.noteLogBean, that.noteLogBean) && Objects.equals(this.notes, that.notes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.noteLogBean, this.notes);
    }
}

