/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.properties.AdditionalProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;

public class AssetSummary
extends AssetDescriptor {
    private static final long serialVersionUID = 1L;

    protected AssetSummary() {
    }

    public AssetSummary(Asset assetBean) {
        super(assetBean);
    }

    public AssetSummary(AssetSummary templateAssetSummary) {
        super(templateAssetSummary);
    }

    public AssetElementType getType() {
        ElementType elementType = this.assetBean.getType();
        if (elementType == null) {
            return null;
        }
        return new AssetElementType(elementType);
    }

    public String getGUID() {
        return this.assetBean.getGUID();
    }

    public String getURL() {
        return this.assetBean.getURL();
    }

    public String getQualifiedName() {
        return this.assetBean.getQualifiedName();
    }

    public String getDisplayName() {
        return this.assetBean.getDisplayName();
    }

    public String getShortDescription() {
        return this.assetBean.getShortDescription();
    }

    public String getDescription() {
        return this.assetBean.getDescription();
    }

    public String getOwner() {
        return this.assetBean.getOwner();
    }

    public OwnerType getOwnerType() {
        return this.assetBean.getOwnerType();
    }

    public List<String> getZoneMembership() {
        return this.assetBean.getZoneMembership();
    }

    public List<AssetClassification> getAssetClassifications() {
        List<ElementClassification> classifications = this.assetBean.getClassifications();
        if (classifications == null) {
            return null;
        }
        ArrayList<AssetClassification> assetClassifications = new ArrayList<AssetClassification>();
        for (ElementClassification classification : classifications) {
            if (classification == null) continue;
            assetClassifications.add(new AssetClassification((AssetDescriptor)this, classification));
        }
        if (assetClassifications.isEmpty()) {
            return null;
        }
        return assetClassifications;
    }

    public Map<String, String> getOrigins() {
        return this.assetBean.getOrigin();
    }

    public String getLatestChange() {
        return this.assetBean.getLatestChange();
    }

    public Map<String, Object> getExtendedProperties() {
        return this.assetBean.getExtendedProperties();
    }

    public AdditionalProperties getAdditionalProperties() {
        Map<String, String> additionalProperties = this.assetBean.getAdditionalProperties();
        if (additionalProperties == null) {
            return null;
        }
        return new AdditionalProperties((AssetDescriptor)this, additionalProperties);
    }

    public String toString() {
        return this.assetBean.toString();
    }
}

