/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class VirtualConnection
extends Connection {
    private static final long serialVersionUID = 1L;
    private List<EmbeddedConnection> embeddedConnections = null;

    public static ElementType getVirtualConnectionType() {
        String elementTypeId = "82f9c664-e59d-484c-a8f3-17088c23a2f3";
        String elementTypeName = "VirtualConnection";
        long elementTypeVersion = 1L;
        String elementTypeDescription = "A connector for a virtual resource that needs to retrieve data from multiple places.";
        String elementAccessServiceURL = null;
        ElementOrigin elementOrigin = ElementOrigin.LOCAL_COHORT;
        String elementHomeMetadataCollectionId = null;
        ElementType elementType = new ElementType();
        elementType.setElementTypeId("82f9c664-e59d-484c-a8f3-17088c23a2f3");
        elementType.setElementTypeName("VirtualConnection");
        elementType.setElementTypeVersion(1L);
        elementType.setElementTypeDescription("A connector for a virtual resource that needs to retrieve data from multiple places.");
        elementType.setElementSourceServer(elementAccessServiceURL);
        elementType.setElementOrigin(elementOrigin);
        elementType.setElementMetadataCollectionId(elementHomeMetadataCollectionId);
        return elementType;
    }

    public VirtualConnection() {
    }

    public VirtualConnection(VirtualConnection templateVirtualConnection) {
        super(templateVirtualConnection);
        if (templateVirtualConnection != null) {
            this.embeddedConnections = templateVirtualConnection.getEmbeddedConnections();
        }
    }

    public List<EmbeddedConnection> getEmbeddedConnections() {
        if (this.embeddedConnections == null) {
            return null;
        }
        if (this.embeddedConnections.isEmpty()) {
            return null;
        }
        return new ArrayList<EmbeddedConnection>(this.embeddedConnections);
    }

    public void setEmbeddedConnections(List<EmbeddedConnection> embeddedConnections) {
        this.embeddedConnections = embeddedConnections;
    }

    @Override
    public String toString() {
        return "VirtualConnection{displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", connectorType=" + this.getConnectorType() + ", userId='" + this.getUserId() + '\'' + ", encryptedPassword='" + this.getEncryptedPassword() + '\'' + ", clearPassword='" + this.getClearPassword() + '\'' + ", endpoint=" + this.getEndpoint() + ", configurationProperties=" + this.getConfigurationProperties() + ", securedProperties=" + this.getSecuredProperties() + ", assetSummary='" + this.getAssetSummary() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", securityTags=" + this.getSecurityTags() + ", searchKeywords=" + this.getSearchKeywords() + ", latestChange='" + this.getLatestChange() + '\'' + ", latestChangeDetails=" + this.getLatestChangeDetails() + ", confidentialityGovernanceClassification=" + this.getConfidentialityGovernanceClassification() + ", confidenceGovernanceClassification=" + this.getConfidenceGovernanceClassification() + ", criticalityGovernanceClassification=" + this.getCriticalityGovernanceClassification() + ", retentionGovernanceClassification=" + this.getRetentionGovernanceClassification() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", classifications=" + this.getClassifications() + ", extendedProperties=" + this.getExtendedProperties() + ", headerVersion=" + this.getHeaderVersion() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        VirtualConnection that = (VirtualConnection)objectToCompare;
        return Objects.equals(this.getEmbeddedConnections(), that.getEmbeddedConnections());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEmbeddedConnections());
    }
}

