/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;

public class AssetRelatedAsset
extends AssetReferenceable {
    private static final long serialVersionUID = 1L;
    protected Asset assetBean;
    protected String relationshipTypeName;
    protected String relationshipAttributeName;
    protected RelatedAssetProperties relatedAssetProperties;

    public AssetRelatedAsset(Asset assetBean, String relationshipTypeName, String relationshipAttributeName, RelatedAssetProperties relatedAssetProperties) {
        super(assetBean);
        this.assetBean = assetBean == null ? new Asset() : new Asset(assetBean);
        this.relationshipTypeName = relationshipTypeName;
        this.relationshipAttributeName = relationshipAttributeName;
        this.relatedAssetProperties = relatedAssetProperties;
    }

    public AssetRelatedAsset(AssetDescriptor parentAsset, Asset assetBean, String relationshipTypeName, String relationshipAttributeName, RelatedAssetProperties relatedAssetProperties) {
        super(assetBean);
        this.assetBean = assetBean == null ? new Asset() : new Asset(assetBean);
        this.relationshipTypeName = relationshipTypeName;
        this.relationshipAttributeName = relationshipAttributeName;
        this.relatedAssetProperties = relatedAssetProperties;
    }

    public AssetRelatedAsset(AssetDescriptor parentAsset, AssetRelatedAsset templateRelatedAsset) {
        super(parentAsset, templateRelatedAsset);
        if (templateRelatedAsset == null) {
            this.assetBean = new Asset();
            this.relatedAssetProperties = null;
            this.relationshipTypeName = null;
            this.relationshipAttributeName = null;
        } else {
            this.assetBean = templateRelatedAsset.getAssetBean();
            this.relatedAssetProperties = templateRelatedAsset.relatedAssetProperties;
            this.relationshipTypeName = templateRelatedAsset.getRelationshipTypeName();
            this.relationshipAttributeName = templateRelatedAsset.getRelationshipAttributeName();
        }
    }

    protected Asset getAssetBean() {
        return this.assetBean;
    }

    public String getDisplayName() {
        return this.assetBean.getDisplayName();
    }

    public String getShortDescription() {
        return this.assetBean.getShortDescription();
    }

    public String getDescription() {
        return this.assetBean.getDescription();
    }

    public String getOwner() {
        return this.assetBean.getOwner();
    }

    public String getRelationshipTypeName() {
        return this.relationshipTypeName;
    }

    public String getRelationshipAttributeName() {
        return this.relationshipAttributeName;
    }

    public RelatedAssetProperties getRelatedAssetProperties() throws PropertyServerException, UserNotAuthorizedException {
        if (this.relatedAssetProperties != null) {
            this.relatedAssetProperties.refresh();
        }
        return this.relatedAssetProperties;
    }

    @Override
    public String toString() {
        return this.assetBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetRelatedAsset that = (AssetRelatedAsset)objectToCompare;
        return Objects.equals(this.assetBean, that.assetBean) && Objects.equals(this.relationshipTypeName, that.relationshipTypeName) && Objects.equals(this.relationshipAttributeName, that.relationshipAttributeName) && Objects.equals(this.relatedAssetProperties, that.relatedAssetProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.assetBean, this.relationshipTypeName, this.relationshipAttributeName, this.relatedAssetProperties);
    }
}

