/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;

public abstract class AssetElementHeader
extends AssetPropertyBase {
    private static final long serialVersionUID = 1L;
    private ElementHeader elementHeaderBean = null;

    protected AssetElementHeader(AssetDescriptor parentAsset) {
        super(parentAsset);
    }

    protected AssetElementHeader(ElementHeader elementHeaderBean) {
        super(null);
        this.elementHeaderBean = elementHeaderBean == null ? new ElementHeader() : elementHeaderBean;
    }

    protected AssetElementHeader(AssetDescriptor parentAsset, ElementHeader elementHeaderBean) {
        super(parentAsset);
        this.elementHeaderBean = elementHeaderBean == null ? new ElementHeader() : elementHeaderBean;
    }

    protected AssetElementHeader(AssetDescriptor parentAsset, AssetElementHeader assetElementHeader) {
        super(parentAsset, assetElementHeader);
        this.elementHeaderBean = assetElementHeader == null ? new ElementHeader() : assetElementHeader.getElementHeaderBean();
    }

    protected void setBean(ElementHeader elementHeaderBean) {
        this.elementHeaderBean = elementHeaderBean;
    }

    protected ElementHeader getElementHeaderBean() {
        return this.elementHeaderBean;
    }

    public AssetElementType getType() {
        if (this.elementHeaderBean == null) {
            return null;
        }
        ElementType elementTypeBean = this.elementHeaderBean.getType();
        if (elementTypeBean == null) {
            return null;
        }
        return new AssetElementType(elementTypeBean);
    }

    public String getGUID() {
        if (this.elementHeaderBean == null) {
            return null;
        }
        return this.elementHeaderBean.getGUID();
    }

    public String getURL() {
        if (this.elementHeaderBean == null) {
            return null;
        }
        return this.elementHeaderBean.getURL();
    }

    public List<AssetClassification> getAssetClassifications() {
        if (this.elementHeaderBean == null) {
            return null;
        }
        List<ElementClassification> classifications = this.elementHeaderBean.getClassifications();
        if (classifications == null) {
            return null;
        }
        ArrayList<AssetClassification> assetClassifications = new ArrayList<AssetClassification>();
        for (ElementClassification classification : classifications) {
            if (classification == null) continue;
            assetClassifications.add(new AssetClassification(this.getParentAsset(), classification));
        }
        if (assetClassifications.isEmpty()) {
            return null;
        }
        return assetClassifications;
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.elementHeaderBean == null) {
            return null;
        }
        return this.elementHeaderBean.getExtendedProperties();
    }

    public String toString() {
        if (this.elementHeaderBean == null) {
            return new ElementHeader().toString();
        }
        return this.elementHeaderBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetElementHeader)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetElementHeader that = (AssetElementHeader)objectToCompare;
        return Objects.equals(this.getElementHeaderBean(), that.getElementHeaderBean());
    }

    @Override
    public int hashCode() {
        if (this.elementHeaderBean == null) {
            return new ElementHeader().hashCode();
        }
        return this.elementHeaderBean.hashCode();
    }
}

