/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AdditionalProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetMeaning;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSecurityTags;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Meaning;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SecurityTags;

public class AssetReferenceable
extends AssetElementHeader {
    private static final long serialVersionUID = 1L;
    protected Referenceable referenceableBean;

    protected AssetReferenceable(AssetDescriptor parentAsset) {
        super(parentAsset);
        this.referenceableBean = new Referenceable();
    }

    protected AssetReferenceable(Referenceable referenceableBean) {
        super(referenceableBean);
        this.referenceableBean = referenceableBean == null ? new Referenceable() : referenceableBean;
    }

    protected AssetReferenceable(AssetDescriptor parentAsset, Referenceable referenceableBean) {
        super(parentAsset, referenceableBean);
        this.referenceableBean = referenceableBean == null ? new Referenceable() : referenceableBean;
    }

    public AssetReferenceable(AssetDescriptor parentAsset, AssetReferenceable template) {
        super(parentAsset, template);
        this.referenceableBean = template == null ? new Referenceable() : template.getReferenceableBean();
    }

    protected void setBean(Referenceable referenceableBean) {
        super.setBean(referenceableBean);
        this.referenceableBean = referenceableBean;
    }

    protected Referenceable getReferenceableBean() {
        return this.referenceableBean;
    }

    public String getQualifiedName() {
        return this.referenceableBean.getQualifiedName();
    }

    public List<AssetMeaning> getMeanings() {
        List<Meaning> meanings = this.referenceableBean.getMeanings();
        if (meanings != null) {
            ArrayList<AssetMeaning> assetMeanings = new ArrayList<AssetMeaning>();
            for (Meaning meaning : meanings) {
                if (meaning == null) continue;
                assetMeanings.add(new AssetMeaning(this.parentAsset, meaning));
            }
            if (!assetMeanings.isEmpty()) {
                return assetMeanings;
            }
        }
        return null;
    }

    public AssetSecurityTags getSecurityTags() {
        SecurityTags bean = this.referenceableBean.getSecurityTags();
        if (bean != null) {
            return new AssetSecurityTags(this.parentAsset, bean);
        }
        return null;
    }

    public AdditionalProperties getAdditionalProperties() {
        Map<String, String> additionalProperties = this.referenceableBean.getAdditionalProperties();
        if (additionalProperties == null) {
            return null;
        }
        return new AdditionalProperties(super.getParentAsset(), additionalProperties);
    }

    @Override
    public String toString() {
        return this.referenceableBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetReferenceable that = (AssetReferenceable)objectToCompare;
        return Objects.equals(this.referenceableBean, that.referenceableBean);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.referenceableBean);
    }
}

