/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedMediaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedMediaUsage;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelatedMediaReference
extends ExternalReference {
    private static final long serialVersionUID = 1L;
    protected RelatedMediaType mediaType = null;
    protected List<RelatedMediaUsage> mediaUsageList = null;

    public RelatedMediaReference() {
    }

    public RelatedMediaReference(RelatedMediaReference templateRelatedMediaReference) {
        super(templateRelatedMediaReference);
        if (templateRelatedMediaReference != null) {
            this.mediaType = templateRelatedMediaReference.getMediaType();
            this.mediaUsageList = templateRelatedMediaReference.getMediaUsageList();
        }
    }

    public RelatedMediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(RelatedMediaType mediaType) {
        this.mediaType = mediaType;
    }

    public List<RelatedMediaUsage> getMediaUsageList() {
        if (this.mediaUsageList == null) {
            return null;
        }
        return new ArrayList<RelatedMediaUsage>(this.mediaUsageList);
    }

    public void setMediaUsageList(List<RelatedMediaUsage> mediaUsageList) {
        this.mediaUsageList = mediaUsageList;
    }

    @Override
    public String toString() {
        return "RelatedMediaReference{mediaId='" + this.referenceId + "', linkDescription='" + this.linkDescription + "', displayName='" + this.displayName + "', uri='" + this.uri + "', resourceDescription='" + this.resourceDescription + "', version='" + this.version + "', organization='" + this.organization + "', mediaType=" + this.mediaType + ", mediaUsageList=" + this.mediaUsageList + ", qualifiedName='" + this.qualifiedName + "', additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + "', url='" + this.url + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RelatedMediaReference that = (RelatedMediaReference)objectToCompare;
        return this.getMediaType() == that.getMediaType() && Objects.equals(this.getMediaUsageList(), that.getMediaUsageList());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMediaType(), this.getMediaUsageList());
    }
}

