/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum RelatedMediaType implements Serializable
{
    IMAGE(0, 0, "Image", "The media is an image."),
    AUDIO(1, 1, "Audio", "The media is an audio recording."),
    DOCUMENT(2, 2, "Document", "The media is a text document - probably rich text."),
    VIDEO(3, 3, "Video", "The media is a video recording."),
    OTHER(99, 99, "Other", "The media type is not supported.");

    public static final String ENUM_TYPE_GUID = "9548390c-69f5-4dc6-950d-6fdffb257b56";
    public static final String ENUM_TYPE_NAME = "MediaType";
    private final int openTypeOrdinal;
    private final int ordinal;
    private final String name;
    private final String description;
    private static final long serialVersionUID = 1L;

    private RelatedMediaType(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "RelatedMediaType{mediaTypeCode=" + this.ordinal + ", mediaTypeName='" + this.name + "', mediaTypeDescription='" + this.description + "'}";
    }
}

