/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.GovernedReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SchemaAttribute.class, name="SchemaAttribute"), @JsonSubTypes.Type(value=SchemaType.class, name="SchemaType")})
public abstract class SchemaElement
extends GovernedReferenceable {
    private static final long serialVersionUID = 1L;
    protected boolean isDeprecated = false;
    protected String displayName = null;
    protected String description = null;
    protected String anchorGUID = null;
    protected boolean isCalculatedValue = false;
    protected String expression = null;

    public SchemaElement() {
    }

    public SchemaElement(SchemaElement template) {
        super(template);
        if (template != null) {
            this.isDeprecated = template.getIsDeprecated();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.anchorGUID = template.getAnchorGUID();
            this.isCalculatedValue = template.isCalculatedValue();
            this.expression = template.getExpression();
        }
    }

    public boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public void setIsDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAnchorGUID() {
        return this.anchorGUID;
    }

    public void setAnchorGUID(String anchorGUID) {
        this.anchorGUID = anchorGUID;
    }

    public boolean isCalculatedValue() {
        return this.isCalculatedValue;
    }

    public void setCalculatedValue(boolean calculatedValue) {
        this.isCalculatedValue = calculatedValue;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public abstract SchemaElement cloneSchemaElement();

    @Override
    public String toString() {
        return "SchemaElement{isDeprecated=" + this.isDeprecated + ", displayName='" + this.displayName + "', description='" + this.description + "', anchorGUID='" + this.anchorGUID + "', isCalculatedValue=" + this.isCalculatedValue + ", expression='" + this.expression + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", securityTags=" + this.getSecurityTags() + ", searchKeywords=" + this.getSearchKeywords() + ", latestChange='" + this.getLatestChange() + "', latestChangeDetails=" + this.getLatestChangeDetails() + ", confidentialityGovernanceClassification=" + this.getConfidentialityGovernanceClassification() + ", confidenceGovernanceClassification=" + this.getConfidenceGovernanceClassification() + ", criticalityGovernanceClassification=" + this.getCriticalityGovernanceClassification() + ", retentionGovernanceClassification=" + this.getRetentionGovernanceClassification() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + "', URL='" + this.getURL() + "', classifications=" + this.getClassifications() + ", extendedProperties=" + this.getExtendedProperties() + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaElement that = (SchemaElement)objectToCompare;
        return this.isDeprecated == that.isDeprecated && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.anchorGUID, that.anchorGUID);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isDeprecated, this.displayName, this.description, this.anchorGUID);
    }
}

