/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueDefinition;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueSet;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ValidValueDefinition.class, name="ValidValueDefinition"), @JsonSubTypes.Type(value=ValidValueSet.class, name="ValidValueSet")})
public class ValidValue
extends Referenceable {
    private static final long serialVersionUID = 1L;
    protected String displayName = null;
    protected String description = null;
    protected String usage = null;
    protected String scope = null;
    protected String preferredValue = null;
    protected boolean isDeprecated = false;

    public ValidValue() {
    }

    public ValidValue(ValidValue template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.usage = template.getUsage();
            this.scope = template.getScope();
            this.preferredValue = template.getPreferredValue();
            this.isDeprecated = template.getIsDeprecated();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getPreferredValue() {
        return this.preferredValue;
    }

    public void setPreferredValue(String preferredValue) {
        this.preferredValue = preferredValue;
    }

    public boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public void setIsDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    @Override
    public String toString() {
        return "ValidValue{URL='" + this.getURL() + "', extendedProperties=" + this.getExtendedProperties() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", origin=" + this.getOrigin() + ", versions=" + this.getVersions() + ", GUID='" + this.getGUID() + "', classifications=" + this.getClassifications() + ", headerVersion=" + this.getHeaderVersion() + ", qualifiedName='" + this.getQualifiedName() + "', displayName='" + this.displayName + "', description='" + this.description + "', usage='" + this.usage + "', scope='" + this.scope + "', preferredValue='" + this.preferredValue + "', isDeprecated=" + this.isDeprecated + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ValidValue that = (ValidValue)objectToCompare;
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.usage, that.usage) && Objects.equals(this.scope, that.scope) && Objects.equals(this.isDeprecated, that.isDeprecated) && Objects.equals(this.preferredValue, that.preferredValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.description, this.usage, this.scope, this.preferredValue, this.isDeprecated);
    }
}

